/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.graphql;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.graphql.GraphqlProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.json.JsonObject;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.message.BasicHeader;

@UriEndpoint(firstVersion="3.0.0", scheme="graphql", title="GraphQL", syntax="graphql:httpUri", category={Category.API}, producerOnly=true, lenientProperties=true)
public class GraphqlEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true)
    private URI httpUri;
    @UriParam
    private String proxyHost;
    @UriParam(label="security", secret=true)
    private String accessToken;
    @UriParam(label="security", secret=true)
    private String username;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam(label="security", defaultValue="Bearer")
    private String jwtAuthorizationType;
    @UriParam
    private String query;
    @UriParam
    private String queryFile;
    @UriParam
    private String operationName;
    @UriParam
    private JsonObject variables;
    @UriParam
    private String variablesHeader;
    @UriParam
    private String queryHeader;
    private CloseableHttpClient httpClient;

    public GraphqlEndpoint(String uri, Component component) {
        super(uri, component);
    }

    protected void doStop() throws Exception {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    public Producer createProducer() throws Exception {
        return new GraphqlProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages at this endpoint: " + this.getEndpointUri());
    }

    public CloseableHttpClient getHttpclient() {
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
        return this.httpClient;
    }

    private CloseableHttpClient createHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (this.proxyHost != null) {
            String[] parts = this.proxyHost.split(":");
            String hostname = parts[0];
            int port = Integer.parseInt(parts[1]);
            httpClientBuilder.setProxy(new HttpHost(hostname, port));
        }
        if (this.accessToken != null) {
            String authType = "Bearer";
            if (this.jwtAuthorizationType != null) {
                authType = this.jwtAuthorizationType;
            }
            httpClientBuilder.setDefaultHeaders(Arrays.asList(new BasicHeader("Authorization", (Object)(authType + " " + this.accessToken))));
        }
        if (this.username != null && this.password != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(null, -1), (Credentials)new UsernamePasswordCredentials(this.username, this.password.toCharArray()));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        return httpClientBuilder.build();
    }

    public URI getHttpUri() {
        return this.httpUri;
    }

    public void setHttpUri(URI httpUri) {
        this.httpUri = httpUri;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getQuery() {
        if (this.query == null && this.queryFile != null) {
            try {
                this.query = IOHelper.loadText((InputStream)ObjectHelper.loadResourceAsStream((String)this.queryFile, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
            }
            catch (IOException e) {
                throw new RuntimeCamelException("Failed to read query file: " + this.queryFile, (Throwable)e);
            }
        }
        return this.query;
    }

    public void setJwtAuthorizationType(String jwtAuthorizationType) {
        this.jwtAuthorizationType = jwtAuthorizationType;
    }

    public String getJwtAuthorizationType() {
        return this.jwtAuthorizationType;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQueryFile() {
        return this.queryFile;
    }

    public void setQueryFile(String queryFile) {
        this.queryFile = queryFile;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public JsonObject getVariables() {
        return this.variables;
    }

    public void setVariables(JsonObject variables) {
        this.variables = variables;
    }

    public String getVariablesHeader() {
        return this.variablesHeader;
    }

    public void setVariablesHeader(String variablesHeader) {
        this.variablesHeader = variablesHeader;
    }

    public String getQueryHeader() {
        return this.queryHeader;
    }

    public void setQueryHeader(String queryHeader) {
        this.queryHeader = queryHeader;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public boolean isLenientProperties() {
        return true;
    }
}

