/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.util.DelegatingScript;
import java.io.Reader;
import org.apache.camel.Experimental;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.endpoint.EndpointRouteBuilder;
import org.apache.camel.dsl.groovy.common.GroovyDSL;
import org.apache.camel.dsl.support.EndpointRouteBuilderLoaderSupport;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

@Experimental
@ManagedResource(description="Managed GroovyRoutesBuilderLoader")
@RoutesLoader(value="groovy")
public class GroovyRoutesBuilderLoader
extends EndpointRouteBuilderLoaderSupport {
    public static final String EXTENSION = "groovy";

    public GroovyRoutesBuilderLoader() {
        super(EXTENSION);
    }

    protected void doLoadEndpointRouteBuilder(Reader reader, EndpointRouteBuilder builder) {
        ImportCustomizer ic = new ImportCustomizer();
        ic.addStarImports(new String[]{"org.apache.camel"});
        ic.addStarImports(new String[]{"org.apache.camel.spi"});
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.addCompilationCustomizers(new CompilationCustomizer[]{ic});
        cc.setScriptBaseClass(DelegatingScript.class.getName());
        ClassLoader cl = builder.getContext().getApplicationContextClassLoader() != null ? builder.getContext().getApplicationContextClassLoader() : Thread.currentThread().getContextClassLoader();
        GroovyShell sh = new GroovyShell(cl, new Binding(), cc);
        DelegatingScript script = (DelegatingScript)sh.parse(reader);
        script.setDelegate((Object)new GroovyDSL(builder));
        script.run();
    }
}

