/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.groovy.extend;

import groovy.lang.Closure;
import java.lang.reflect.Method;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.DataFormatClause;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.groovy.dataformat.XmlParserDataFormat;
import org.apache.camel.groovy.dataformat.XmlSlurperDataFormat;
import org.apache.camel.groovy.extend.ClosureAggregationStrategy;
import org.apache.camel.groovy.extend.ClosureExpression;
import org.apache.camel.groovy.extend.ClosureProcessor;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.DelayDefinition;
import org.apache.camel.model.DynamicRouterDefinition;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.IdempotentConsumerDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.LoopDefinition;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.model.RoutingSlipDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.model.ThrottleDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.model.WireTapDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.ExpressionSupport;

public final class CamelGroovyMethods {
    private CamelGroovyMethods() {
    }

    public static ProcessorDefinition<?> process(ProcessorDefinition<?> self, Closure<?> processorLogic) {
        return self.process(CamelGroovyMethods.toProcessor(processorLogic));
    }

    public WireTapDefinition<?> newExchange(WireTapDefinition<?> self, Closure<?> processorLogic) {
        return self.newExchange(CamelGroovyMethods.toProcessor(processorLogic));
    }

    public static OnExceptionDefinition onRedelivery(OnExceptionDefinition self, Closure<Exchange> processorLogic) {
        return self.onRedelivery(CamelGroovyMethods.toProcessor(processorLogic));
    }

    public static ProcessorDefinition<?> enrich(ProcessorDefinition<?> self, String resourceUri, Closure<Exchange> aggregationLogic) {
        return self.enrich(resourceUri, CamelGroovyMethods.toAggregationStrategy(aggregationLogic));
    }

    public static ProcessorDefinition<?> pollEnrich(ProcessorDefinition<?> self, String resourceUri, Closure<Exchange> aggregationLogic) {
        return self.pollEnrich(resourceUri, CamelGroovyMethods.toAggregationStrategy(aggregationLogic));
    }

    public static ProcessorDefinition<?> pollEnrich(ProcessorDefinition<?> self, String resourceUri, long timeout, Closure<Exchange> aggregationLogic) {
        return self.pollEnrich(resourceUri, timeout, CamelGroovyMethods.toAggregationStrategy(aggregationLogic));
    }

    public static MulticastDefinition aggregationStrategy(MulticastDefinition self, Closure<Exchange> aggregationLogic) {
        return self.aggregationStrategy(CamelGroovyMethods.toAggregationStrategy(aggregationLogic));
    }

    public static RecipientListDefinition<?> aggregationStrategy(RecipientListDefinition<?> self, Closure<Exchange> aggregationLogic) {
        return self.aggregationStrategy(CamelGroovyMethods.toAggregationStrategy(aggregationLogic));
    }

    public static SplitDefinition aggregationStrategy(SplitDefinition self, Closure<Exchange> aggregationLogic) {
        return self.aggregationStrategy(CamelGroovyMethods.toAggregationStrategy(aggregationLogic));
    }

    public static AggregateDefinition aggregationStrategy(AggregateDefinition self, Closure<Exchange> aggregationLogic) {
        return self.aggregationStrategy(CamelGroovyMethods.toAggregationStrategy(aggregationLogic));
    }

    public static MulticastDefinition onPrepare(MulticastDefinition self, Closure<Exchange> processorLogic) {
        return self.onPrepare(CamelGroovyMethods.toProcessor(processorLogic));
    }

    public static RecipientListDefinition<?> onPrepare(RecipientListDefinition<?> self, Closure<Exchange> processorLogic) {
        return self.onPrepare(CamelGroovyMethods.toProcessor(processorLogic));
    }

    public static SplitDefinition onPrepare(SplitDefinition self, Closure<Exchange> processorLogic) {
        return self.onPrepare(CamelGroovyMethods.toProcessor(processorLogic));
    }

    public static WireTapDefinition<?> onPrepare(WireTapDefinition<?> self, Closure<Exchange> processorLogic) {
        return self.onPrepare(CamelGroovyMethods.toProcessor(processorLogic));
    }

    public static ProcessorDefinition<?> transform(ProcessorDefinition<?> self, Closure<?> expression) {
        return self.transform((Expression)CamelGroovyMethods.toExpression(expression));
    }

    public static ProcessorDefinition<?> setProperty(ProcessorDefinition<?> self, String name, Closure<?> expression) {
        return self.setProperty(name, (Expression)CamelGroovyMethods.toExpression(expression));
    }

    public static ProcessorDefinition<?> setHeader(ProcessorDefinition<?> self, String name, Closure<?> expression) {
        return self.setHeader(name, (Expression)CamelGroovyMethods.toExpression(expression));
    }

    public static ProcessorDefinition<?> setBody(ProcessorDefinition<?> self, Closure<?> expression) {
        return self.setBody((Expression)CamelGroovyMethods.toExpression(expression));
    }

    public static ProcessorDefinition<?> setFaultBody(ProcessorDefinition<?> self, Closure<?> expression) {
        return self.setFaultBody((Expression)CamelGroovyMethods.toExpression(expression));
    }

    public static ProcessorDefinition<?> sort(ProcessorDefinition<?> self, Closure<?> expression) {
        return self.sort((Expression)CamelGroovyMethods.toExpression(expression));
    }

    public static IdempotentConsumerDefinition idempotentConsumer(ProcessorDefinition<?> self, Closure<?> expression) {
        return self.idempotentConsumer((Expression)CamelGroovyMethods.toExpression(expression));
    }

    public static IdempotentConsumerDefinition idempotentConsumer(ProcessorDefinition<?> self, IdempotentRepository<?> rep, Closure<?> expression) {
        return self.idempotentConsumer((Expression)CamelGroovyMethods.toExpression(expression), rep);
    }

    public static RecipientListDefinition<?> recipientList(ProcessorDefinition<?> self, Closure<?> recipients) {
        return self.recipientList((Expression)CamelGroovyMethods.toExpression(recipients));
    }

    public static RecipientListDefinition<?> recipientList(ProcessorDefinition<?> self, String delimiter, Closure<?> recipients) {
        return self.recipientList((Expression)CamelGroovyMethods.toExpression(recipients), delimiter);
    }

    public static RoutingSlipDefinition<?> routingSlip(ProcessorDefinition<?> self, Closure<?> recipients) {
        return self.routingSlip((Expression)CamelGroovyMethods.toExpression(recipients));
    }

    public static RoutingSlipDefinition<?> routingSlip(ProcessorDefinition<?> self, String delimiter, Closure<?> recipients) {
        return self.routingSlip((Expression)CamelGroovyMethods.toExpression(recipients), delimiter);
    }

    public static DynamicRouterDefinition<?> dynamicRouter(ProcessorDefinition<?> self, Closure<?> expression) {
        return self.dynamicRouter((Expression)CamelGroovyMethods.toExpression(expression));
    }

    public static SplitDefinition split(ProcessorDefinition<?> self, Closure<?> expression) {
        return self.split((Expression)CamelGroovyMethods.toExpression(expression));
    }

    public static ResequenceDefinition resequence(ProcessorDefinition<?> self, Closure<?> expression) {
        return self.resequence((Expression)CamelGroovyMethods.toExpression(expression));
    }

    public static AggregateDefinition aggregate(ProcessorDefinition<?> self, Closure<?> correlationExpression) {
        return self.aggregate((Expression)CamelGroovyMethods.toExpression(correlationExpression));
    }

    public static AggregateDefinition completionSize(AggregateDefinition self, Closure<?> expression) {
        return self.completionSize((Expression)CamelGroovyMethods.toExpression(expression));
    }

    public static AggregateDefinition completionTimeout(AggregateDefinition self, Closure<?> expression) {
        return self.completionTimeout((Expression)CamelGroovyMethods.toExpression(expression));
    }

    public static DelayDefinition delay(ProcessorDefinition<?> self, Closure<?> expression) {
        return self.delay((Expression)CamelGroovyMethods.toExpression(expression));
    }

    public static ThrottleDefinition throttle(ProcessorDefinition<?> self, Closure<?> expression) {
        return self.throttle((Expression)CamelGroovyMethods.toExpression(expression));
    }

    public static LoopDefinition loop(ProcessorDefinition<?> self, Closure<?> expression) {
        return self.loop((Expression)CamelGroovyMethods.toExpression(expression));
    }

    public static WireTapDefinition<?> newExchangeBody(WireTapDefinition<?> self, Closure<?> expression) {
        return self.newExchangeBody((Expression)CamelGroovyMethods.toExpression(expression));
    }

    public static WireTapDefinition<?> newExchangeHeader(WireTapDefinition<?> self, String header, Closure<?> expression) {
        return self.newExchangeHeader(header, (Expression)CamelGroovyMethods.toExpression(expression));
    }

    public static FilterDefinition filter(ProcessorDefinition<?> self, Closure<?> predicate) {
        return self.filter((Predicate)CamelGroovyMethods.toExpression(predicate));
    }

    public static ProcessorDefinition<?> validate(ProcessorDefinition<?> self, Closure<?> predicate) {
        return self.validate((Predicate)CamelGroovyMethods.toExpression(predicate));
    }

    public static ChoiceDefinition when(ChoiceDefinition self, Closure<?> predicate) {
        return self.when((Predicate)CamelGroovyMethods.toExpression(predicate));
    }

    public static TryDefinition onWhen(TryDefinition self, Closure<?> predicate) {
        return self.onWhen((Predicate)CamelGroovyMethods.toExpression(predicate));
    }

    public static OnExceptionDefinition onWhen(OnExceptionDefinition self, Closure<?> predicate) {
        return self.onWhen((Predicate)CamelGroovyMethods.toExpression(predicate));
    }

    public static OnExceptionDefinition handled(OnExceptionDefinition self, Closure<?> predicate) {
        return self.handled((Predicate)CamelGroovyMethods.toExpression(predicate));
    }

    public static OnExceptionDefinition continued(OnExceptionDefinition self, Closure<?> predicate) {
        return self.continued((Predicate)CamelGroovyMethods.toExpression(predicate));
    }

    public static OnExceptionDefinition retryWhile(OnExceptionDefinition self, Closure<?> predicate) {
        return self.retryWhile((Predicate)CamelGroovyMethods.toExpression(predicate));
    }

    public static OnCompletionDefinition onWhen(OnCompletionDefinition self, Closure<?> predicate) {
        return self.onWhen((Predicate)CamelGroovyMethods.toExpression(predicate));
    }

    public static CatchDefinition onWhen(CatchDefinition self, Closure<?> predicate) {
        return self.onWhen((Predicate)CamelGroovyMethods.toExpression(predicate));
    }

    public static AggregateDefinition completionPredicate(AggregateDefinition self, Closure<?> predicate) {
        return self.completionPredicate((Predicate)CamelGroovyMethods.toExpression(predicate));
    }

    public static InterceptDefinition when(InterceptDefinition self, Closure<?> predicate) {
        return self.when((Predicate)CamelGroovyMethods.toExpression(predicate));
    }

    public static InterceptSendToEndpointDefinition when(InterceptSendToEndpointDefinition self, Closure<?> predicate) {
        return self.when((Predicate)CamelGroovyMethods.toExpression(predicate));
    }

    public static AggregationStrategy aggregator(RouteBuilder self, Closure<Exchange> aggregationLogic) {
        return CamelGroovyMethods.toAggregationStrategy(aggregationLogic);
    }

    public static Expression expression(RouteBuilder self, Closure<?> expression) {
        return CamelGroovyMethods.toExpression(expression);
    }

    public static Predicate predicate(RouteBuilder self, Closure<?> predicate) {
        return CamelGroovyMethods.toExpression(predicate);
    }

    public static Processor processor(RouteBuilder self, Closure<Exchange> processor) {
        return CamelGroovyMethods.toProcessor(processor);
    }

    public static <T> T expression(ExpressionClause<T> self, Closure<?> expression) {
        return (T)self.expression((Expression)CamelGroovyMethods.toExpression(expression));
    }

    static ExpressionSupport toExpression(Closure<?> closure) {
        return new ClosureExpression(closure);
    }

    static Processor toProcessor(Closure<?> closure) {
        return new ClosureProcessor(closure);
    }

    static AggregationStrategy toAggregationStrategy(Closure<Exchange> closure) {
        return new ClosureAggregationStrategy(closure);
    }

    public static ProcessorDefinition<?> gnode(DataFormatClause<?> self, boolean namespaceAware) {
        return CamelGroovyMethods.dataFormat(self, CamelGroovyMethods.parser(namespaceAware));
    }

    public static ProcessorDefinition<?> gnode(DataFormatClause<?> self) {
        return CamelGroovyMethods.gnode(self, true);
    }

    public static ProcessorDefinition<?> gpath(DataFormatClause<?> self, boolean namespaceAware) {
        return CamelGroovyMethods.dataFormat(self, CamelGroovyMethods.slurper(namespaceAware));
    }

    public static ProcessorDefinition<?> gpath(DataFormatClause<?> self) {
        return CamelGroovyMethods.gpath(self, true);
    }

    private static DataFormatDefinition slurper(boolean namespaceAware) {
        return new DataFormatDefinition((DataFormat)new XmlSlurperDataFormat(namespaceAware));
    }

    private static DataFormatDefinition parser(boolean namespaceAware) {
        return new DataFormatDefinition((DataFormat)new XmlParserDataFormat(namespaceAware));
    }

    private static ProcessorDefinition<?> dataFormat(DataFormatClause<?> self, DataFormatDefinition format) {
        try {
            Method m = self.getClass().getDeclaredMethod("dataFormat", DataFormatDefinition.class);
            m.setAccessible(true);
            return (ProcessorDefinition)m.invoke(self, format);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown DataFormat operation", e);
        }
    }
}

