/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.groovy;

import java.io.LineNumberReader;
import java.io.StringReader;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;

public class GroovyValidationException
extends Exception {
    private final String script;

    public GroovyValidationException(String script, Throwable cause) {
        super(cause);
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public int getIndex() {
        MultipleCompilationErrorsException me;
        Message gm;
        Throwable throwable = this.getCause();
        if (throwable instanceof MultipleCompilationErrorsException && (gm = (me = (MultipleCompilationErrorsException)throwable).getErrorCollector().getLastError()) instanceof SyntaxErrorMessage) {
            SyntaxErrorMessage sem = (SyntaxErrorMessage)gm;
            LineNumberReader lr = new LineNumberReader(new StringReader(this.script));
            int pos = -1;
            for (int i = 1; i < sem.getCause().getLine(); ++i) {
                try {
                    String line = lr.readLine();
                    pos += line.length() + System.lineSeparator().length();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return pos += sem.getCause().getStartColumn();
        }
        return -1;
    }
}

