/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.groovy;

import groovy.lang.GroovyShell;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Ordered;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.language.groovy.GroovyPreCompiledClassLoader;
import org.apache.camel.language.groovy.GroovyScriptClassLoader;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.CompileStrategy;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.GroovyScriptCompiler;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.SimpleEventNotifierSupport;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="groovy-script-compiler")
@ManagedResource(description="Managed GroovyScriptCompiler")
public class DefaultGroovyScriptCompiler
extends ServiceSupport
implements CamelContextAware,
GroovyScriptCompiler,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultGroovyScriptCompiler.class);
    private GroovyPreCompiledClassLoader groovyPreCompiledClassLoader;
    private GroovyScriptClassLoader classLoader;
    private CamelContext camelContext;
    private EventNotifier notifier;
    private String scriptPattern;
    private boolean preloadCompiled;
    private String workDir;
    private long taken;
    private int counter;
    private int preloadCounter;
    private long last;
    private boolean reload;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @ManagedAttribute(description="Total Groovy compilation time in millis")
    public long getCompileTime() {
        return this.taken;
    }

    @ManagedAttribute(description="Number of Groovy sources that has been compiled")
    public int getClassesSize() {
        return this.classLoader.size();
    }

    @ManagedAttribute(description="Number of times Groovy compiler has executed")
    public int getCompileCounter() {
        return this.counter;
    }

    @ManagedAttribute(description="Number of pre-compiled Groovy sources on startup")
    public int getPreloadedCounter() {
        return this.preloadCounter;
    }

    @ManagedAttribute(description="Directories to scan for Groovy source to be pre-compiled")
    public String getScriptPattern() {
        return this.scriptPattern;
    }

    public void setScriptPattern(String scriptPattern) {
        this.scriptPattern = scriptPattern;
    }

    @ManagedAttribute(description="Whether to preload existing compiled Groovy sources from the workdir directory on startup")
    public boolean isPreloadCompiled() {
        return this.preloadCompiled;
    }

    public void setPreloadCompiled(boolean preloadCompiled) {
        this.preloadCompiled = preloadCompiled;
    }

    @ManagedAttribute(description="Directory for storing compiled Groovy sources as class files")
    public String getWorkDir() {
        return this.workDir;
    }

    @ManagedAttribute(description="Whether re-compiling is enabled")
    public boolean isRecompileEnabled() {
        return this.reload;
    }

    @ManagedOperation(description="The class names for the compiled Groovy sources")
    public Set<String> compiledClassNames() {
        return this.classLoader.getCompiledClassNames();
    }

    @ManagedAttribute(description="Last time the Groovy compiler was used")
    public long getLastCompilationTimestamp() {
        return this.last;
    }

    public void recompile(Resource resource) throws Exception {
        if (resource.exists()) {
            this.doCompile(List.of(resource), false);
        }
    }

    protected void doBuild() throws Exception {
        CamelContext context = this.getCamelContext();
        if (context != null) {
            this.classLoader = (GroovyScriptClassLoader)context.getClassResolver().getClassLoader("GroovyScriptClassLoader");
            if (this.classLoader == null) {
                ClassLoader applicationContextClassLoader = context.getApplicationContextClassLoader();
                this.classLoader = applicationContextClassLoader != null ? new GroovyScriptClassLoader(applicationContextClassLoader) : new GroovyScriptClassLoader();
                context.getClassResolver().addClassLoader((ClassLoader)this.classLoader);
                context.getCamelContextExtension().addContextPlugin(GroovyScriptClassLoader.class, (Object)this.classLoader);
            }
            this.groovyPreCompiledClassLoader = new GroovyPreCompiledClassLoader(this.classLoader);
            String profile = context.getCamelContextExtension().getProfile();
            if ("dev".equals(profile)) {
                this.reload = true;
                if (this.notifier == null) {
                    this.notifier = new ReloadNotifier();
                    this.getCamelContext().getManagementStrategy().addEventNotifier(this.notifier);
                }
            }
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        CompileStrategy cs = (CompileStrategy)this.camelContext.getCamelContextExtension().getContextPlugin(CompileStrategy.class);
        if (cs != null && cs.getWorkDir() != null) {
            this.workDir = cs.getWorkDir() + "/groovy";
        }
        if (this.scriptPattern != null) {
            LOG.debug("Loading Groovy sources from: {}", (Object)this.scriptPattern);
            this.doCompile(this.scanForGroovySources(this.scriptPattern), true);
            if (this.preloadCounter > 0 || this.counter > 0) {
                LOG.info("Loaded Groovy sources from: {} (pre-loaded:{} compiled:{} time:{}ms)", new Object[]{this.scriptPattern, this.preloadCounter, this.counter, this.taken});
            }
        }
    }

    protected Collection<Resource> scanForGroovySources(String scriptPattern) throws Exception {
        ArrayList<Resource> list = new ArrayList<Resource>();
        PackageScanResourceResolver resolver = PluginHelper.getPackageScanResourceResolver((CamelContext)this.camelContext);
        for (String pattern : scriptPattern.split(",")) {
            for (Resource resource : resolver.findResources(pattern, n -> true)) {
                if (!resource.exists() || !"classpath".equals(resource.getScheme()) && !"file".equals(resource.getScheme())) continue;
                list.add(resource);
            }
        }
        return list;
    }

    protected void doCompile(Collection<Resource> resources, boolean bootstrap) throws Exception {
        File[] files;
        File dir;
        ArrayList<String> cps = new ArrayList<String>();
        LinkedHashMap<String, String> codes = new LinkedHashMap<String, String>();
        LinkedHashMap<String, byte[]> classes = new LinkedHashMap<String, byte[]>();
        for (Resource resource : resources) {
            File[] loc = resource.getLocation();
            if (loc == null) continue;
            loc = StringHelper.after((String)loc, (String)":", (String)loc);
            String name = FileUtil.onlyName((String)loc);
            boolean found = false;
            if (loc.endsWith(".groovy")) {
                found = true;
                String code = IOHelper.loadText((InputStream)resource.getInputStream());
                codes.put(name, code);
            } else if (loc.endsWith(".class") && this.isPreloadCompiled() && bootstrap) {
                found = true;
                byte[] data = (byte[])this.camelContext.getTypeConverter().convertTo(byte[].class, (Object)resource.getInputStream());
                if (data != null) {
                    classes.put(name, data);
                }
            }
            if (!found) continue;
            String cp = FileUtil.onlyPath((String)loc);
            if (cp == null) {
                cp = ".";
            }
            if (cps.contains(cp)) continue;
            cps.add(cp);
        }
        if (this.workDir != null && this.isPreloadCompiled() && bootstrap && (dir = new File(this.workDir)).exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (File f : files) {
                byte[] data;
                String name;
                if (!f.isFile() || !f.exists() || !(name = f.getName()).endsWith(".class") || (data = (byte[])this.camelContext.getTypeConverter().convertTo(byte[].class, (Object)f)) == null) continue;
                classes.put(FileUtil.onlyName((String)name), data);
            }
        }
        if (classes.isEmpty() && codes.isEmpty()) {
            return;
        }
        if (bootstrap && this.isPreloadCompiled() && !classes.isEmpty()) {
            Set<String> loaded = this.doPreloadClasses(classes);
            if (!loaded.isEmpty()) {
                LOG.debug("Loaded {} pre-compiled Groovy sources", (Object)loaded.size());
            }
            for (String load : loaded) {
                codes.remove(load);
            }
        }
        if (!codes.isEmpty()) {
            this.doCompileCode(codes, cps);
        }
    }

    private Set<String> doPreloadClasses(Map<String, byte[]> classes) {
        HashSet<String> answer = new HashSet<String>();
        for (Map.Entry<String, byte[]> entry : classes.entrySet()) {
            String name = entry.getKey();
            this.groovyPreCompiledClassLoader.addClass(name, entry.getValue());
            try {
                Class<?> clazz = this.groovyPreCompiledClassLoader.findClass(name);
                this.classLoader.addClass(clazz.getName(), clazz);
                answer.add(name);
            }
            catch (ClassNotFoundException e) {
                LOG.debug("Error loading pre-compiled class: {}. This exception is ignored.", (Object)name, (Object)e);
            }
        }
        IOHelper.close((Closeable)this.groovyPreCompiledClassLoader);
        this.preloadCounter = answer.size();
        return answer;
    }

    private void doCompileCode(Map<String, String> codes, List<String> cps) throws Exception {
        ClassLoader cl;
        StopWatch watch = new StopWatch();
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.setClasspathList(cps);
        if (this.reload) {
            cc.setRecompileGroovySource(true);
        }
        if (this.workDir != null) {
            LOG.debug("Writing compiled Groovy classes to directory: {}", (Object)this.workDir);
            cc.setTargetDirectory(this.workDir);
        }
        if ((cl = this.camelContext.getApplicationContextClassLoader()) == null) {
            cl = GroovyShell.class.getClassLoader();
        }
        GroovyShell shell = new GroovyShell(cl, cc);
        for (String code : codes.values()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Compiling Groovy source:\n{}", (Object)code);
            }
            ++this.counter;
            Class clazz = shell.getClassLoader().parseClass(code);
            if (clazz == null) continue;
            String name = clazz.getName();
            LOG.debug("Compiled Groovy class: {}", (Object)name);
            this.classLoader.removeClass(name);
            this.classLoader.addClass(name, clazz);
        }
        this.taken += watch.taken();
        this.last = System.currentTimeMillis();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.counter > 0) {
            LOG.debug("Compiled {} Groovy sources in {} millis", (Object)this.counter, (Object)this.taken);
        }
        IOHelper.close((Closeable[])new Closeable[]{this.classLoader, this.groovyPreCompiledClassLoader});
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.notifier != null) {
            this.getCamelContext().getManagementStrategy().removeEventNotifier(this.notifier);
            this.notifier = null;
        }
    }

    private final class ReloadNotifier
    extends SimpleEventNotifierSupport
    implements Ordered {
        private ReloadNotifier() {
        }

        public void notify(CamelEvent event) throws Exception {
            if ((event instanceof CamelEvent.CamelContextReloadingEvent || event instanceof CamelEvent.RouteReloadedEvent) && DefaultGroovyScriptCompiler.this.scriptPattern != null) {
                if (DefaultGroovyScriptCompiler.this.classLoader != null) {
                    DefaultGroovyScriptCompiler.this.classLoader.clear();
                }
                LOG.info("Re-compiling Groovy sources from: {}", (Object)DefaultGroovyScriptCompiler.this.scriptPattern);
                DefaultGroovyScriptCompiler.this.doCompile(DefaultGroovyScriptCompiler.this.scanForGroovySources(DefaultGroovyScriptCompiler.this.scriptPattern), false);
            }
        }

        public int getOrder() {
            return 0;
        }
    }
}

