/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.grpc.GrpcConfiguration;
import org.apache.camel.component.grpc.GrpcEndpoint;
import org.apache.camel.component.grpc.GrpcUtils;
import org.apache.camel.impl.DefaultComponent;

public class GrpcComponent
extends DefaultComponent {
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        GrpcConfiguration config = new GrpcConfiguration();
        this.setProperties(config, parameters);
        config.setServiceName(this.extractServiceName(remaining));
        config.setServicePackage(this.extractServicePackage(remaining));
        config.setMethod(GrpcUtils.convertMethod2CamelCase(config.getMethod()));
        GrpcEndpoint endpoint = new GrpcEndpoint(uri, this, config);
        return endpoint;
    }

    private String extractServiceName(String service) {
        return service.substring(service.lastIndexOf(".") + 1);
    }

    private String extractServicePackage(String service) {
        return service.substring(0, service.lastIndexOf("."));
    }
}

