/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.grpc.GrpcComponent;
import org.apache.camel.component.grpc.GrpcConfiguration;
import org.apache.camel.component.grpc.GrpcProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.SynchronousDelegateProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(firstVersion="2.19.0", scheme="grpc", title="gRPC", syntax="grpc:service", producerOnly=true, label="rpc")
public class GrpcEndpoint
extends DefaultEndpoint {
    @UriParam
    protected final GrpcConfiguration configuration;

    public GrpcEndpoint(String uri, GrpcComponent component, GrpcConfiguration config) throws Exception {
        super(uri, (Component)component);
        this.configuration = config;
    }

    public Producer createProducer() throws Exception {
        GrpcProducer producer = new GrpcProducer(this, this.configuration);
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)producer);
        }
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from a gRPC endpoint: " + this.getEndpointUri());
    }

    public boolean isSingleton() {
        return true;
    }
}

