/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc.auth.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import org.apache.camel.component.grpc.GrpcConstants;
import org.apache.camel.component.grpc.auth.jwt.JwtAlgorithm;
import org.apache.camel.component.grpc.auth.jwt.JwtHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtServerInterceptor
implements ServerInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(JwtServerInterceptor.class);
    private static final ServerCall.Listener NOOP_LISTENER = new ServerCall.Listener(){};
    private final JWTVerifier verifier;

    public JwtServerInterceptor(JwtAlgorithm algorithm, String secret, String issuer, String subject) {
        this.verifier = JwtServerInterceptor.prepareJwtVerifier(algorithm, secret, issuer, subject);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        Context ctx;
        String jwtToken = (String)metadata.get(GrpcConstants.GRPC_JWT_METADATA_KEY);
        if (jwtToken == null) {
            call.close(Status.UNAUTHENTICATED.withDescription("JWT Token is missing from metadata"), metadata);
            return NOOP_LISTENER;
        }
        try {
            DecodedJWT verified = this.verifier.verify(jwtToken);
            ctx = Context.current().withValue(GrpcConstants.GRPC_JWT_USER_ID_CTX_KEY, (Object)(verified.getSubject() == null ? "anonymous" : verified.getSubject())).withValue(GrpcConstants.GRPC_JWT_CTX_KEY, (Object)jwtToken);
        }
        catch (Exception e) {
            LOG.debug("JWT token verification failed - Unauthenticated");
            call.close(Status.UNAUTHENTICATED.withDescription(e.getMessage()).withCause((Throwable)e), metadata);
            return NOOP_LISTENER;
        }
        return Contexts.interceptCall((Context)ctx, call, (Metadata)metadata, serverCallHandler);
    }

    public static JWTVerifier prepareJwtVerifier(JwtAlgorithm algorithmName, String secret, String issuer, String subject) {
        try {
            Algorithm algorithm = JwtHelper.selectAlgorithm(algorithmName, secret);
            return JWT.require((Algorithm)algorithm).withIssuer(new String[]{issuer}).withSubject(subject).build();
        }
        catch (JWTCreationException e) {
            throw new IllegalArgumentException("Unable to create JWT verifier", e);
        }
    }
}

