/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc.client;

import org.apache.camel.component.grpc.GrpcConfiguration;
import org.apache.camel.component.grpc.GrpcProducerStrategy;
import org.apache.camel.component.grpc.client.GrpcExchangeForwarder;
import org.apache.camel.component.grpc.client.GrpcSimpleExchangeForwarder;
import org.apache.camel.component.grpc.client.GrpcStreamingExchangeForwarder;

public final class GrpcExchangeForwarderFactory {
    private GrpcExchangeForwarderFactory() {
    }

    public static GrpcExchangeForwarder createExchangeForwarder(GrpcConfiguration configuration, Object grpcStub) {
        if (configuration.getProducerStrategy() == GrpcProducerStrategy.SIMPLE) {
            return new GrpcSimpleExchangeForwarder(configuration, grpcStub);
        }
        if (configuration.getProducerStrategy() == GrpcProducerStrategy.STREAMING) {
            return new GrpcStreamingExchangeForwarder(configuration, grpcStub);
        }
        throw new IllegalStateException("Unsupported producer strategy: " + (Object)((Object)configuration.getProducerStrategy()));
    }
}

