/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class GrpcEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":host:port/service";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "grpc".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "host", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "port", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "service", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(31);
        props.add("serviceAccountResource");
        props.add("synchronous");
        props.add("jwtSubject");
        props.add("trustCertCollectionResource");
        props.add("forwardOnCompleted");
        props.add("jwtIssuer");
        props.add("bridgeErrorHandler");
        props.add("routeControlledStreamObserver");
        props.add("keyPassword");
        props.add("host");
        props.add("maxMessageSize");
        props.add("flowControlWindow");
        props.add("jwtSecret");
        props.add("keyResource");
        props.add("method");
        props.add("autoDiscoverClientInterceptors");
        props.add("exchangePattern");
        props.add("streamRepliesTo");
        props.add("userAgent");
        props.add("consumerStrategy");
        props.add("jwtAlgorithm");
        props.add("negotiationType");
        props.add("lazyStartProducer");
        props.add("port");
        props.add("service");
        props.add("maxConcurrentCallsPerConnection");
        props.add("forwardOnError");
        props.add("producerStrategy");
        props.add("authenticationType");
        props.add("exceptionHandler");
        props.add("keyCertChainResource");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("jwtSecret");
        secretProps.add("keyPassword");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

