/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc.client;

import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProducer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.grpc.GrpcConfiguration;

public class GrpcResponseRouterStreamObserver
implements StreamObserver<Object> {
    private final Endpoint sourceEndpoint;
    private final GrpcConfiguration configuration;
    private final AsyncProducer producer;
    private final Exchange exchange;
    private final AsyncCallback callback;

    public GrpcResponseRouterStreamObserver(GrpcConfiguration configuration, Endpoint sourceEndpoint, AsyncProducer producer, Exchange exchange, AsyncCallback callback) {
        this.configuration = configuration;
        this.sourceEndpoint = sourceEndpoint;
        this.producer = producer;
        this.exchange = exchange;
        this.callback = callback;
    }

    public void onNext(Object o) {
        Exchange newExchange = this.sourceEndpoint.createExchange();
        this.inherit(newExchange);
        newExchange.getIn().setHeader("CamelGrpcEventType", (Object)"onNext");
        newExchange.getIn().setBody(o);
        this.doSend(newExchange);
    }

    public void onError(Throwable throwable) {
        if (this.configuration.isForwardOnError()) {
            Exchange newExchange = this.sourceEndpoint.createExchange();
            this.inherit(newExchange);
            newExchange.getIn().setHeader("CamelGrpcEventType", (Object)"onError");
            newExchange.getIn().setBody((Object)throwable);
            this.doSend(newExchange);
        }
        this.callback.done(true);
    }

    public void onCompleted() {
        if (this.configuration.isForwardOnCompleted()) {
            Exchange newExchange = this.sourceEndpoint.createExchange();
            this.inherit(newExchange);
            newExchange.getIn().setHeader("CamelGrpcEventType", (Object)"onCompleted");
            this.doSend(newExchange);
        }
        this.callback.done(true);
    }

    private void doSend(Exchange newExchange) {
        this.producer.processAsync(newExchange);
    }

    private void inherit(Exchange newExchange) {
        if (this.configuration.isInheritExchangePropertiesForReplies()) {
            for (Map.Entry entry : this.exchange.getProperties().entrySet()) {
                newExchange.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcResponseRouterStreamObserver that = (GrpcResponseRouterStreamObserver)o;
        return Objects.equals(this.sourceEndpoint, that.sourceEndpoint) && Objects.equals(this.producer, that.producer);
    }

    public int hashCode() {
        return Objects.hash(this.sourceEndpoint, this.producer);
    }
}

