/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.LongSerializationPolicy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatContentTypeHeader;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;

@Dataformat(value="json-gson")
@Metadata(includeProperties="unmarshalType,unmarshalTypeName,prettyPrint,contentTypeHeader")
public class GsonDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
DataFormatContentTypeHeader,
CamelContextAware {
    private CamelContext camelContext;
    private Gson gson;
    private Class<?> unmarshalType;
    private String unmarshalTypeName;
    private Type unmarshalGenericType;
    private List<ExclusionStrategy> exclusionStrategies;
    private LongSerializationPolicy longSerializationPolicy;
    private FieldNamingPolicy fieldNamingPolicy;
    private FieldNamingStrategy fieldNamingStrategy;
    private boolean serializeNulls;
    private boolean prettyPrint;
    private String dateFormatPattern;
    private boolean contentTypeHeader = true;

    public GsonDataFormat() {
        this(Object.class);
    }

    public GsonDataFormat(Class<?> unmarshalType) {
        this(null, unmarshalType);
    }

    @Deprecated
    public GsonDataFormat(Class<?> unmarshalType, ExclusionStrategy ... exclusionStrategies) {
        this(null, unmarshalType);
        this.setExclusionStrategies(Arrays.asList(exclusionStrategies));
    }

    public GsonDataFormat(Gson gson, Class<?> unmarshalType) {
        this.gson = gson;
        this.unmarshalType = unmarshalType;
    }

    public GsonDataFormat(Type unmarshalGenericType) {
        this(null, unmarshalGenericType);
    }

    public GsonDataFormat(Gson gson, Type unmarshalGenericType) {
        this.gson = gson;
        this.unmarshalGenericType = unmarshalGenericType;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getDataFormatName() {
        return "json-gson";
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        try (OutputStreamWriter osw = new OutputStreamWriter(stream, ExchangeHelper.getCharsetName((Exchange)exchange));
             BufferedWriter writer = IOHelper.buffered((Writer)osw);){
            this.gson.toJson(graph, (Appendable)writer);
        }
        if (this.contentTypeHeader) {
            if (exchange.hasOut()) {
                exchange.getOut().setHeader("Content-Type", (Object)"application/json");
            } else {
                exchange.getIn().setHeader("Content-Type", (Object)"application/json");
            }
        }
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        try (InputStreamReader isr = new InputStreamReader(stream, ExchangeHelper.getCharsetName((Exchange)exchange));){
            Object object;
            block19: {
                BufferedReader reader;
                block17: {
                    Object object2;
                    block18: {
                        block15: {
                            Object object3;
                            block16: {
                                reader = IOHelper.buffered((Reader)isr);
                                try {
                                    String type = (String)exchange.getIn().getHeader("CamelGsonUnmarshalType", String.class);
                                    if (type == null) break block15;
                                    Class clazz = exchange.getContext().getClassResolver().resolveMandatoryClass(type);
                                    object3 = this.gson.fromJson((Reader)reader, clazz);
                                    if (reader == null) break block16;
                                }
                                catch (Throwable throwable) {
                                    if (reader != null) {
                                        try {
                                            reader.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                reader.close();
                            }
                            return object3;
                        }
                        if (this.unmarshalGenericType != null) break block17;
                        object2 = this.gson.fromJson((Reader)reader, this.unmarshalType);
                        if (reader == null) break block18;
                        reader.close();
                    }
                    return object2;
                }
                object = this.gson.fromJson((Reader)reader, this.unmarshalGenericType);
                if (reader == null) break block19;
                reader.close();
            }
            return object;
        }
    }

    protected void doInit() throws Exception {
        if (this.unmarshalTypeName != null && (this.unmarshalType == null || this.unmarshalType == Object.class)) {
            this.unmarshalType = this.camelContext.getClassResolver().resolveClass(this.unmarshalTypeName);
        }
    }

    protected void doStart() throws Exception {
        if (this.gson == null) {
            GsonBuilder builder = new GsonBuilder();
            if (this.exclusionStrategies != null && !this.exclusionStrategies.isEmpty()) {
                ExclusionStrategy[] strategies = this.exclusionStrategies.toArray(new ExclusionStrategy[this.exclusionStrategies.size()]);
                builder.setExclusionStrategies(strategies);
            }
            if (this.longSerializationPolicy != null) {
                builder.setLongSerializationPolicy(this.longSerializationPolicy);
            }
            if (this.fieldNamingPolicy != null) {
                builder.setFieldNamingPolicy(this.fieldNamingPolicy);
            }
            if (this.fieldNamingStrategy != null) {
                builder.setFieldNamingStrategy(this.fieldNamingStrategy);
            }
            if (this.serializeNulls) {
                builder.serializeNulls();
            }
            if (this.prettyPrint) {
                builder.setPrettyPrinting();
            }
            if (this.dateFormatPattern != null) {
                builder.setDateFormat(this.dateFormatPattern);
            }
            this.gson = builder.create();
        }
    }

    protected void doStop() throws Exception {
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public Type getUnmarshalGenericType() {
        return this.unmarshalType;
    }

    public void setUnmarshalGenericType(Type unmarshalGenericType) {
        this.unmarshalGenericType = unmarshalGenericType;
    }

    public List<ExclusionStrategy> getExclusionStrategies() {
        return this.exclusionStrategies;
    }

    public void setExclusionStrategies(List<ExclusionStrategy> exclusionStrategies) {
        this.exclusionStrategies = exclusionStrategies;
    }

    public LongSerializationPolicy getLongSerializationPolicy() {
        return this.longSerializationPolicy;
    }

    public void setLongSerializationPolicy(LongSerializationPolicy longSerializationPolicy) {
        this.longSerializationPolicy = longSerializationPolicy;
    }

    public FieldNamingPolicy getFieldNamingPolicy() {
        return this.fieldNamingPolicy;
    }

    public void setFieldNamingPolicy(FieldNamingPolicy fieldNamingPolicy) {
        this.fieldNamingPolicy = fieldNamingPolicy;
    }

    public FieldNamingStrategy getFieldNamingStrategy() {
        return this.fieldNamingStrategy;
    }

    public void setFieldNamingStrategy(FieldNamingStrategy fieldNamingStrategy) {
        this.fieldNamingStrategy = fieldNamingStrategy;
    }

    @Deprecated
    public Boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    public boolean isSerializeNulls() {
        return this.serializeNulls;
    }

    @Deprecated
    public void setSerializeNulls(Boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    public void setSerializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    @Deprecated
    public Boolean getPrettyPrinting() {
        return this.prettyPrint;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    @Deprecated
    public void setPrettyPrinting(Boolean prettyPrinting) {
        this.prettyPrint = prettyPrinting;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }

    public boolean isContentTypeHeader() {
        return this.contentTypeHeader;
    }

    public void setContentTypeHeader(boolean contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public Gson getGson() {
        return this.gson;
    }
}

