/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.guava.eventbus;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.guava.eventbus.GuavaEventBusEndpoint;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelEventHandler {
    protected final Logger log = LoggerFactory.getLogger(CamelEventHandler.class);
    protected final GuavaEventBusEndpoint eventBusEndpoint;
    protected final AsyncProcessor processor;

    public CamelEventHandler(GuavaEventBusEndpoint eventBusEndpoint, Processor processor) {
        ObjectHelper.notNull((Object)((Object)eventBusEndpoint), (String)"eventBusEndpoint");
        ObjectHelper.notNull((Object)processor, (String)"processor");
        this.eventBusEndpoint = eventBusEndpoint;
        this.processor = AsyncProcessorConverterHelper.convert((Processor)processor);
    }

    public void doEventReceived(Object event) {
        this.log.trace("Received event: {}", event);
        Exchange exchange = this.eventBusEndpoint.createExchange(event);
        this.log.debug("Processing event: {}", event);
        this.processor.process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
            }
        });
    }
}

