/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.guava.eventbus;

import com.google.common.eventbus.Subscribe;
import org.apache.camel.Processor;
import org.apache.camel.component.guava.eventbus.CamelEventHandler;
import org.apache.camel.component.guava.eventbus.GuavaEventBusConsumer;
import org.apache.camel.component.guava.eventbus.GuavaEventBusEndpoint;

public class FilteringCamelEventHandler
extends CamelEventHandler {
    private final Class<?> eventClass;

    public FilteringCamelEventHandler(GuavaEventBusConsumer consumer, GuavaEventBusEndpoint endpoint, Processor processor, Class<?> eventClass) {
        super(consumer, endpoint, processor);
        this.eventClass = eventClass;
    }

    @Subscribe
    public void eventReceived(Object event) {
        if (this.eventClass == null || this.eventClass.isAssignableFrom(event.getClass())) {
            this.doEventReceived(event);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Cannot process event: {} as its class type: {} is not assignable with: {}", new Object[]{event, event.getClass().getName(), this.eventClass.getName()});
        }
    }
}

