/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.guice;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.util.MainSupport;
import org.apache.camel.view.ModelFileGenerator;
import org.guiceyfruit.Injectors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main
extends MainSupport {
    private static Main instance;
    private InitialContext context;
    private Injector injector;

    public static void main(String ... args) {
        Main main;
        instance = main = new Main();
        main.run(args);
    }

    public static Main getInstance() {
        return instance;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.context = new InitialContext();
        this.injector = (Injector)this.context.lookup(Injector.class.getName());
        this.postProcessContext();
    }

    protected void doStop() throws Exception {
        LOG.info((Object)"Apache Camel terminating");
        if (this.injector != null) {
            this.injector.close();
        }
    }

    protected ProducerTemplate findOrCreateCamelTemplate() {
        Set set;
        if (this.injector != null && !(set = Injectors.getInstancesOf((Injector)this.injector, ProducerTemplate.class)).isEmpty()) {
            return (ProducerTemplate)Iterables.get((Iterable)set, (int)0);
        }
        Iterator i$ = this.getCamelContexts().iterator();
        if (i$.hasNext()) {
            CamelContext camelContext = (CamelContext)i$.next();
            return camelContext.createProducerTemplate();
        }
        throw new IllegalArgumentException("No CamelContexts are available so cannot create a ProducerTemplate!");
    }

    protected Map<String, CamelContext> getCamelContextMap() {
        HashMap answer = Maps.newHashMap();
        if (this.injector != null) {
            Set entries = this.injector.getBindings().entrySet();
            for (Map.Entry entry : entries) {
                Binding binding;
                Object value;
                Key key = (Key)entry.getKey();
                Class keyType = Injectors.getKeyType((Key)key);
                if (keyType == null || !CamelContext.class.isAssignableFrom(keyType) || (value = (binding = (Binding)entry.getValue()).getProvider().get()) == null) continue;
                CamelContext castValue = (CamelContext)CamelContext.class.cast(value);
                answer.put(key.toString(), castValue);
            }
        }
        return answer;
    }

    protected ModelFileGenerator createModelFileGenerator() throws JAXBException {
        return new ModelFileGenerator(JAXBContext.newInstance((String)"org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer"));
    }
}

