/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.guice.impl;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.spi.AnnotationProviderFactory;
import com.google.inject.spi.InjectionAnnotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.Produce;
import org.apache.camel.impl.CamelPostProcessorHelper;
import org.apache.camel.util.ObjectHelper;

@InjectionAnnotation(value=Produce.class)
public class ProduceInjector
extends CamelPostProcessorHelper
implements AnnotationProviderFactory {
    @Inject
    public ProduceInjector(CamelContext camelContext) {
        super(camelContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Provider createProvider(AnnotatedElement member) {
        String injectionPointName;
        Class<?> type;
        Produce inject = member.getAnnotation(Produce.class);
        Objects.nonNull((Object)inject, (String)"@Produce is not present!");
        final String endpointRef = inject.ref();
        final String uri = inject.uri();
        if (member instanceof Field) {
            Field field = (Field)member;
            type = field.getType();
            injectionPointName = field.getName();
            return new Provider(){

                public Object get() {
                    return ProduceInjector.this.getInjectionValue(type, uri, endpointRef, injectionPointName);
                }
            };
        } else {
            if (!(member instanceof Method)) throw new UnsupportedOperationException("Annotated element " + member + " not supported");
            Method method = (Method)member;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) throw new UnsupportedOperationException("Only a single method parameter value supported for @Produce on " + method);
            type = parameterTypes[0];
            injectionPointName = ObjectHelper.getPropertyName((Method)method);
        }
        return new /* invalid duplicate definition of identical inner class */;
    }
}

