/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.guice;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.guice.inject.Injectors;
import org.apache.camel.main.MainSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class Main
extends MainSupport {
    private static Main instance;
    private Injector injector;
    private String jndiProperties;

    public Main() {
        this.addOption((MainSupport.Option)new MainSupport.ParameterOption("j", "jndiProperties", "Sets the classpath based jndi properties file location", "jndiProperties"){

            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setJndiProperties(parameter);
            }
        });
    }

    public void setJndiProperties(String properties) {
        this.jndiProperties = properties;
    }

    public String getJndiProperties() {
        return this.jndiProperties;
    }

    public static void main(String ... args) throws Exception {
        Main main;
        instance = main = new Main();
        main.run(args);
    }

    public static Main getInstance() {
        return instance;
    }

    protected void setInjector(Injector injector) {
        this.injector = injector;
    }

    protected Injector getInjector() {
        return this.injector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Injector getInjectorFromContext() throws Exception {
        InitialContext context = null;
        URL jndiPropertiesUrl = null;
        if (ObjectHelper.isNotEmpty((Object)this.jndiProperties)) {
            jndiPropertiesUrl = ((Object)((Object)this)).getClass().getResource(this.jndiProperties);
        }
        if (jndiPropertiesUrl != null) {
            Properties properties = new Properties();
            BufferedInputStream bis = null;
            try {
                bis = IOHelper.buffered((InputStream)jndiPropertiesUrl.openStream());
                properties.load(bis);
            }
            finally {
                IOHelper.close((Closeable)bis);
            }
            context = new InitialContext(properties);
        } else {
            context = new InitialContext();
        }
        return (Injector)context.lookup(Injector.class.getName());
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.setInjector(this.getInjectorFromContext());
        this.postProcessContext();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.injector != null) {
            Injectors.close(this.injector);
        }
    }

    protected ProducerTemplate findOrCreateCamelTemplate() {
        Set<ProducerTemplate> set;
        if (this.injector != null && !(set = Injectors.getInstancesOf(this.injector, ProducerTemplate.class)).isEmpty()) {
            return (ProducerTemplate)Iterables.getOnlyElement(set);
        }
        Iterator i$ = this.getCamelContexts().iterator();
        if (i$.hasNext()) {
            CamelContext camelContext = (CamelContext)i$.next();
            return camelContext.createProducerTemplate();
        }
        throw new IllegalArgumentException("No CamelContext is available so cannot create a ProducerTemplate!");
    }

    protected Map<String, CamelContext> getCamelContextMap() {
        HashMap answer = Maps.newHashMap();
        if (this.injector != null) {
            Set entries = this.injector.getBindings().entrySet();
            for (Map.Entry entry : entries) {
                Binding binding;
                Object value;
                Key key = (Key)entry.getKey();
                Class<?> keyType = Injectors.getKeyType(key);
                if (keyType == null || !CamelContext.class.isAssignableFrom(keyType) || (value = (binding = (Binding)entry.getValue()).getProvider().get()) == null) continue;
                CamelContext castValue = (CamelContext)CamelContext.class.cast(value);
                answer.put(key.toString(), castValue);
            }
        }
        return answer;
    }
}

