/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;

public final class HazelcastComponentHelper {
    private static final HashMap<String, Integer> MAPPING = new HashMap();

    private HazelcastComponentHelper() {
    }

    public static void copyHeaders(Exchange ex) {
        Map headers = ex.getIn().getHeaders();
        if (headers.containsKey("CamelHazelcastObjectId")) {
            headers.remove("CamelHazelcastObjectId");
        }
        if (headers.containsKey("CamelHazelcastOperationType")) {
            headers.remove("CamelHazelcastOperationType");
        }
        if (ex.hasOut()) {
            ex.getOut().setHeaders(headers);
        }
    }

    public static void setListenerHeaders(Exchange ex, String listenerType, String listenerAction, String cacheName) {
        ex.getIn().setHeader("CamelHazelcastCacheName", (Object)cacheName);
        HazelcastComponentHelper.setListenerHeaders(ex, listenerType, listenerAction);
    }

    public static void setListenerHeaders(Exchange ex, String listenerType, String listenerAction) {
        ex.getIn().setHeader("CamelHazelcastListenerAction", (Object)listenerAction);
        ex.getIn().setHeader("CamelHazelcastListenerType", (Object)listenerType);
        ex.getIn().setHeader("CamelHazelcastListenerTime", (Object)new Date().getTime());
    }

    public static int lookupOperationNumber(Exchange exchange, int defaultOperation) {
        return HazelcastComponentHelper.extractOperationNumber(exchange.getIn().getHeader("CamelHazelcastOperationType"), defaultOperation);
    }

    public static int extractOperationNumber(Object value, int defaultOperation) {
        int operation = defaultOperation;
        if (value instanceof String) {
            operation = HazelcastComponentHelper.mapToOperationNumber((String)value);
        } else if (value instanceof Integer) {
            operation = (Integer)value;
        }
        return operation;
    }

    private static int mapToOperationNumber(String operationName) {
        if (MAPPING.containsKey(operationName)) {
            return MAPPING.get(operationName);
        }
        throw new IllegalArgumentException(String.format("Operation '%s' is not supported by this component.", operationName));
    }

    private static void addMapping(HashMap<String, Integer> mapping, String operationName, int operationNumber) {
        mapping.put(operationName, operationNumber);
        mapping.put(String.valueOf(operationNumber), operationNumber);
    }

    static {
        HazelcastComponentHelper.addMapping(MAPPING, "put", 1);
        HazelcastComponentHelper.addMapping(MAPPING, "delete", 2);
        HazelcastComponentHelper.addMapping(MAPPING, "get", 3);
        HazelcastComponentHelper.addMapping(MAPPING, "update", 4);
        HazelcastComponentHelper.addMapping(MAPPING, "query", 5);
        HazelcastComponentHelper.addMapping(MAPPING, "getAll", 6);
        HazelcastComponentHelper.addMapping(MAPPING, "clear", 7);
        HazelcastComponentHelper.addMapping(MAPPING, "evict", 12);
        HazelcastComponentHelper.addMapping(MAPPING, "evictAll", 13);
        HazelcastComponentHelper.addMapping(MAPPING, "putIfAbsent", 8);
        HazelcastComponentHelper.addMapping(MAPPING, "addAll", 9);
        HazelcastComponentHelper.addMapping(MAPPING, "removeAll", 10);
        HazelcastComponentHelper.addMapping(MAPPING, "retainAll", 11);
        HazelcastComponentHelper.addMapping(MAPPING, "valueCount", 14);
        HazelcastComponentHelper.addMapping(MAPPING, "containsKey", 15);
        HazelcastComponentHelper.addMapping(MAPPING, "containsValue", 16);
        HazelcastComponentHelper.addMapping(MAPPING, "keySet", 41);
        HazelcastComponentHelper.addMapping(MAPPING, "removevalue", 17);
        HazelcastComponentHelper.addMapping(MAPPING, "increment", 20);
        HazelcastComponentHelper.addMapping(MAPPING, "decrement", 21);
        HazelcastComponentHelper.addMapping(MAPPING, "setvalue", 22);
        HazelcastComponentHelper.addMapping(MAPPING, "destroy", 23);
        HazelcastComponentHelper.addMapping(MAPPING, "compareAndSet", 24);
        HazelcastComponentHelper.addMapping(MAPPING, "getAndAdd", 25);
        HazelcastComponentHelper.addMapping(MAPPING, "add", 31);
        HazelcastComponentHelper.addMapping(MAPPING, "offer", 32);
        HazelcastComponentHelper.addMapping(MAPPING, "peek", 33);
        HazelcastComponentHelper.addMapping(MAPPING, "poll", 34);
        HazelcastComponentHelper.addMapping(MAPPING, "remainingCapacity", 35);
        HazelcastComponentHelper.addMapping(MAPPING, "drainTo", 36);
        HazelcastComponentHelper.addMapping(MAPPING, "publish", 37);
        HazelcastComponentHelper.addMapping(MAPPING, "capacity", 40);
        HazelcastComponentHelper.addMapping(MAPPING, "readonceHead", 38);
        HazelcastComponentHelper.addMapping(MAPPING, "readonceTail", 39);
    }
}

