/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.queue;

import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ItemListener;
import com.hazelcast.core.HazelcastInstance;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.hazelcast.HazelcastDefaultConsumer;
import org.apache.camel.component.hazelcast.listener.CamelItemListener;
import org.apache.camel.component.hazelcast.queue.HazelcastQueueConfiguration;
import org.apache.camel.component.hazelcast.queue.HazelcastQueueConsumerMode;
import org.apache.camel.component.hazelcast.queue.HazelcastQueueEndpoint;

public class HazelcastQueueConsumer
extends HazelcastDefaultConsumer {
    private final Processor processor;
    private ExecutorService executor;
    private QueueConsumerTask queueConsumerTask;
    private HazelcastQueueConfiguration config;

    public HazelcastQueueConsumer(HazelcastInstance hazelcastInstance, Endpoint endpoint, Processor processor, String cacheName, HazelcastQueueConfiguration configuration) {
        super(hazelcastInstance, endpoint, processor, cacheName);
        this.processor = processor;
        this.config = configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = ((HazelcastQueueEndpoint)this.getEndpoint()).createExecutor();
        CamelItemListener camelItemListener = new CamelItemListener(this, this.cacheName);
        this.queueConsumerTask = new QueueConsumerTask(camelItemListener);
        this.executor.submit(this.queueConsumerTask);
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class QueueConsumerTask
    implements Runnable {
        CamelItemListener camelItemListener;

        public QueueConsumerTask(CamelItemListener camelItemListener) {
            this.camelItemListener = camelItemListener;
        }

        @Override
        public void run() {
            IQueue queue = HazelcastQueueConsumer.this.hazelcastInstance.getQueue(HazelcastQueueConsumer.this.cacheName);
            if (HazelcastQueueConsumer.this.config.getQueueConsumerMode() == HazelcastQueueConsumerMode.LISTEN) {
                queue.addItemListener((ItemListener)this.camelItemListener, true);
            }
            if (HazelcastQueueConsumer.this.config.getQueueConsumerMode() == HazelcastQueueConsumerMode.POLL) {
                while (HazelcastQueueConsumer.this.isRunAllowed()) {
                    try {
                        Object body = queue.poll(HazelcastQueueConsumer.this.config.getPollingTimeout(), TimeUnit.MILLISECONDS);
                        Exchange exchange = HazelcastQueueConsumer.this.getEndpoint().createExchange();
                        exchange.getOut().setBody(body);
                        try {
                            HazelcastQueueConsumer.this.processor.process(exchange);
                        }
                        catch (Exception e) {
                            HazelcastQueueConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

