/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.queue;

import com.hazelcast.collection.IQueue;
import com.hazelcast.core.HazelcastInstance;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.HazelcastDefaultProducer;
import org.apache.camel.component.hazelcast.HazelcastOperation;

public class HazelcastQueueProducer
extends HazelcastDefaultProducer {
    private IQueue<Object> queue;

    public HazelcastQueueProducer(HazelcastInstance hazelcastInstance, HazelcastDefaultEndpoint endpoint, String queueName) {
        super(endpoint);
        this.queue = hazelcastInstance.getQueue(queueName);
    }

    public void process(Exchange exchange) throws Exception {
        Map headers = exchange.getIn().getHeaders();
        Object drainToCollection = null;
        if (headers.containsKey("CamelHazelcastDrainToCollection")) {
            drainToCollection = headers.get("CamelHazelcastDrainToCollection");
        }
        HazelcastOperation operation = this.lookupOperation(exchange);
        switch (operation) {
            case ADD: {
                this.add(exchange);
                break;
            }
            case PUT: {
                this.put(exchange);
                break;
            }
            case POLL: {
                this.poll(exchange);
                break;
            }
            case PEEK: {
                this.peek(exchange);
                break;
            }
            case OFFER: {
                this.offer(exchange);
                break;
            }
            case REMOVE_VALUE: {
                this.remove(exchange);
                break;
            }
            case REMAINING_CAPACITY: {
                this.remainingCapacity(exchange);
                break;
            }
            case REMOVE_ALL: {
                this.removeAll(exchange);
                break;
            }
            case REMOVE_IF: {
                this.removeIf(exchange);
                break;
            }
            case DRAIN_TO: {
                this.drainTo(drainToCollection, exchange);
                break;
            }
            case TAKE: {
                this.take(exchange);
                break;
            }
            case RETAIN_ALL: {
                this.retainAll(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The value '%s' is not allowed for parameter '%s' on the QUEUE cache.", new Object[]{operation, "CamelHazelcastOperationType"}));
            }
        }
        HazelcastComponentHelper.copyHeaders(exchange);
    }

    private void add(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.queue.add(body);
    }

    private void put(Exchange exchange) throws InterruptedException {
        Object body = exchange.getIn().getBody();
        this.queue.put(body);
    }

    private void poll(Exchange exchange) {
        exchange.getOut().setBody(this.queue.poll());
    }

    private void peek(Exchange exchange) {
        exchange.getOut().setBody(this.queue.peek());
    }

    private void offer(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.queue.offer(body);
    }

    private void remove(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        if (body != null) {
            this.queue.remove(body);
        } else {
            this.queue.remove();
        }
    }

    private void remainingCapacity(Exchange exchange) {
        exchange.getOut().setBody((Object)this.queue.remainingCapacity());
    }

    private void drainTo(Collection c, Exchange exchange) {
        exchange.getOut().setBody((Object)this.queue.drainTo(c));
        exchange.getOut().setHeader("CamelHazelcastDrainToCollection", (Object)c);
    }

    private void removeAll(Exchange exchange) {
        Collection body = (Collection)exchange.getIn().getBody(Collection.class);
        this.queue.removeAll(body);
    }

    private void removeIf(Exchange exchange) {
        Predicate filter = (Predicate)exchange.getIn().getBody(Predicate.class);
        exchange.getOut().setBody((Object)this.queue.removeIf(filter));
    }

    private void take(Exchange exchange) throws InterruptedException {
        exchange.getOut().setBody(this.queue.take());
    }

    private void retainAll(Exchange exchange) {
        Collection body = (Collection)exchange.getIn().getBody(Collection.class);
        this.queue.retainAll(body);
    }
}

