/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.policy;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Route;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.hazelcast.HazelcastUtil;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Route policy using Hazelcast as clustered lock")
public class HazelcastRoutePolicy
extends RoutePolicySupport
implements CamelContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastRoutePolicy.class);
    private final boolean managedInstance;
    private final AtomicBoolean leader;
    private final Set<Route> suspendedRoutes;
    private Route route;
    private CamelContext camelContext;
    private ExecutorService executorService;
    private HazelcastInstance instance;
    private String lockMapName;
    private String lockKey;
    private String lockValue;
    private long tryLockTimeout;
    private TimeUnit tryLockTimeoutUnit;
    private IMap<String, String> locks;
    private volatile Future<Void> future;
    private boolean shouldStopConsumer;

    public HazelcastRoutePolicy() {
        this(HazelcastUtil.newInstance(), true);
    }

    public HazelcastRoutePolicy(HazelcastInstance instance) {
        this(instance, false);
    }

    public HazelcastRoutePolicy(HazelcastInstance instance, boolean managedInstance) {
        this.instance = instance;
        this.managedInstance = managedInstance;
        this.suspendedRoutes = new HashSet<Route>();
        this.leader = new AtomicBoolean();
        this.lockMapName = null;
        this.lockKey = null;
        this.lockValue = null;
        this.tryLockTimeout = 10000L;
        this.tryLockTimeoutUnit = TimeUnit.MILLISECONDS;
        this.locks = null;
        this.future = null;
        this.shouldStopConsumer = true;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void onInit(Route route) {
        super.onInit(route);
        this.route = route;
    }

    public void onStart(Route route) {
        if (!this.leader.get() && this.shouldStopConsumer) {
            this.stopConsumer(route);
        }
    }

    public synchronized void onStop(Route route) {
        this.suspendedRoutes.remove(route);
    }

    public synchronized void onSuspend(Route route) {
        this.suspendedRoutes.remove(route);
    }

    protected void doStart() throws Exception {
        StringHelper.notEmpty((String)this.lockMapName, (String)"lockMapName", (Object)((Object)this));
        StringHelper.notEmpty((String)this.lockKey, (String)"lockKey", (Object)((Object)this));
        StringHelper.notEmpty((String)this.lockValue, (String)"lockValue", (Object)((Object)this));
        this.executorService = this.getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, "HazelcastRoutePolicy");
        this.locks = this.instance.getMap(this.lockMapName);
        this.future = this.executorService.submit(this::acquireLeadership);
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
        if (this.managedInstance) {
            this.instance.shutdown();
        }
        this.getCamelContext().getExecutorServiceManager().shutdownGraceful(this.executorService);
        super.doStop();
    }

    protected void setLeader(boolean isLeader) {
        if (isLeader && this.leader.compareAndSet(false, isLeader)) {
            LOGGER.info("Leadership taken (map={}, key={}, val={})", new Object[]{this.lockMapName, this.lockKey, this.lockValue});
            this.startAllStoppedConsumers();
        } else if (!this.leader.getAndSet(isLeader) && isLeader) {
            LOGGER.info("Leadership lost (map={}, key={} val={})", new Object[]{this.lockMapName, this.lockKey, this.lockValue});
        }
    }

    private synchronized void stopConsumer(Route route) {
        try {
            if (!this.suspendedRoutes.contains(route)) {
                LOGGER.debug("Stopping consumer for {} ({})", (Object)route.getId(), (Object)route.getConsumer());
                this.stopConsumer(route.getConsumer());
                this.suspendedRoutes.add(route);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private synchronized void startAllStoppedConsumers() {
        try {
            for (Route route : this.suspendedRoutes) {
                LOGGER.debug("Starting consumer for {} ({})", (Object)route.getId(), (Object)route.getConsumer());
                this.startConsumer(route.getConsumer());
            }
            this.suspendedRoutes.clear();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @ManagedAttribute(description="The route id")
    public String getRouteId() {
        if (this.route != null) {
            return this.route.getId();
        }
        return null;
    }

    @ManagedAttribute(description="The consumer endpoint", mask=true)
    public String getEndpointUrl() {
        if (this.route != null && this.route.getConsumer() != null && this.route.getConsumer().getEndpoint() != null) {
            return this.route.getConsumer().getEndpoint().toString();
        }
        return null;
    }

    @ManagedAttribute(description="The lock map name")
    public String getLockMapName() {
        return this.lockMapName;
    }

    public void setLockMapName(String lockMapName) {
        this.lockMapName = lockMapName;
    }

    @ManagedAttribute(description="Whether to stop consumer when starting up and failed to become master")
    public boolean isShouldStopConsumer() {
        return this.shouldStopConsumer;
    }

    public void setShouldStopConsumer(boolean shouldStopConsumer) {
        this.shouldStopConsumer = shouldStopConsumer;
    }

    @ManagedAttribute(description="The lock key")
    public String getLockKey() {
        return this.lockKey;
    }

    public void setLockKey(String lockKey) {
        this.lockKey = lockKey;
    }

    @ManagedAttribute(description="The lock value")
    public String getLockValue() {
        return this.lockValue;
    }

    public void setLockValue(String lockValue) {
        this.lockValue = lockValue;
    }

    @ManagedAttribute(description="Timeout used by slaves to try to obtain the lock to become new master")
    public long getTryLockTimeout() {
        return this.tryLockTimeout;
    }

    public void setTryLockTimeout(long tryLockTimeout) {
        this.tryLockTimeout = tryLockTimeout;
    }

    public void setTryLockTimeout(long tryLockTimeout, TimeUnit tryLockTimeoutUnit) {
        this.tryLockTimeout = tryLockTimeout;
        this.tryLockTimeoutUnit = tryLockTimeoutUnit;
    }

    @ManagedAttribute(description="Timeout unit")
    public TimeUnit getTryLockTimeoutUnit() {
        return this.tryLockTimeoutUnit;
    }

    public void setTryLockTimeoutUnit(TimeUnit tryLockTimeoutUnit) {
        this.tryLockTimeoutUnit = tryLockTimeoutUnit;
    }

    @ManagedAttribute(description="Is this route the master or a slave")
    public boolean isLeader() {
        return this.leader.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Void acquireLeadership() throws Exception {
        boolean locked = false;
        while (this.isRunAllowed()) {
            try {
                locked = this.locks.tryLock((Object)this.lockKey, this.tryLockTimeout, this.tryLockTimeoutUnit);
                if (locked) {
                    this.locks.put((Object)this.lockKey, (Object)this.lockValue);
                    this.setLeader(true);
                    Thread.sleep(Long.MAX_VALUE);
                    continue;
                }
                LOGGER.debug("Failed to acquire lock (map={}, key={}, val={}) after {} {}", new Object[]{this.lockMapName, this.lockKey, this.lockValue, this.tryLockTimeout, this.tryLockTimeoutUnit.name()});
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (Exception e) {
                this.getExceptionHandler().handleException((Throwable)e);
                continue;
            }
            finally {
                if (locked) {
                    this.locks.remove((Object)this.lockKey);
                    this.locks.unlock((Object)this.lockKey);
                    locked = false;
                }
                this.setLeader(false);
                continue;
            }
            break;
        }
        return null;
    }
}

