/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.seda;

import com.hazelcast.collection.IQueue;
import com.hazelcast.transaction.TransactionContext;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaEndpoint;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultExchangeHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastSedaConsumer
extends DefaultConsumer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(HazelcastSedaConsumer.class);
    private final HazelcastSedaEndpoint endpoint;
    private final AsyncProcessor processor;
    private ExecutorService executor;

    public HazelcastSedaConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = (HazelcastSedaEndpoint)endpoint;
        this.processor = AsyncProcessorConverterHelper.convert((Processor)processor);
    }

    protected void doStart() throws Exception {
        int concurrentConsumers = this.endpoint.getConfiguration().getConcurrentConsumers();
        this.executor = this.endpoint.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, this.endpoint.getEndpointUri(), concurrentConsumers);
        for (int i = 0; i < concurrentConsumers; ++i) {
            this.executor.execute(this);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.executor != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown(this.executor);
            this.executor = null;
        }
        super.doStop();
    }

    @Override
    public void run() {
        IQueue queue = this.endpoint.getHazelcastInstance().getQueue(this.endpoint.getConfiguration().getQueueName());
        while (queue != null && this.isRunAllowed()) {
            final Exchange exchange = this.createExchange(true);
            TransactionContext transactionCtx = null;
            try {
                Object body;
                if (this.endpoint.getConfiguration().isTransacted() && (transactionCtx = this.endpoint.getHazelcastInstance().newTransactionContext()) != null) {
                    LOG.trace("Begin transaction: {}", (Object)transactionCtx.getTxnId());
                    transactionCtx.beginTransaction();
                    queue = transactionCtx.getQueue(this.endpoint.getConfiguration().getQueueName());
                }
                if ((body = queue.poll((long)this.endpoint.getConfiguration().getPollTimeout(), TimeUnit.MILLISECONDS)) != null) {
                    if (body instanceof DefaultExchangeHolder) {
                        DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)((DefaultExchangeHolder)body));
                    } else {
                        exchange.getIn().setBody(body);
                    }
                    try {
                        final TransactionContext txc = transactionCtx;
                        this.processor.process(exchange, new AsyncCallback(){

                            public void done(boolean asyncDone) {
                                if (exchange.getException() != null) {
                                    if (txc != null) {
                                        txc.rollbackTransaction();
                                    }
                                    HazelcastSedaConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                                }
                                if (exchange.getException() == null && txc != null) {
                                    LOG.trace("Commit transaction: {}", (Object)txc.getTxnId());
                                    txc.commitTransaction();
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        LOG.error("Hzlq Exception caught: {}", (Object)e, (Object)e);
                        if (transactionCtx == null) continue;
                        LOG.trace("Rollback transaction: {}", (Object)transactionCtx.getTxnId());
                        transactionCtx.rollbackTransaction();
                    }
                    continue;
                }
                if (transactionCtx == null) continue;
                transactionCtx.commitTransaction();
            }
            catch (InterruptedException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Hzlq Consumer Interrupted: {}", (Object)e, (Object)e);
            }
            catch (Throwable e) {
                if (transactionCtx != null) {
                    LOG.trace("Rollback transaction: {}", (Object)transactionCtx.getTxnId());
                    try {
                        transactionCtx.rollbackTransaction();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.getExceptionHandler().handleException("Error processing exchange", exchange, e);
                try {
                    Thread.sleep(this.endpoint.getConfiguration().getOnErrorDelay());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

