/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.list;

import com.hazelcast.collection.IList;
import com.hazelcast.core.HazelcastInstance;
import java.util.Collection;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.HazelcastDefaultProducer;
import org.apache.camel.component.hazelcast.HazelcastOperation;

public class HazelcastListProducer
extends HazelcastDefaultProducer {
    private final IList<Object> list;

    public HazelcastListProducer(HazelcastInstance hazelcastInstance, HazelcastDefaultEndpoint endpoint, String listName) {
        super(endpoint);
        this.list = hazelcastInstance.getList(listName);
    }

    public void process(Exchange exchange) throws Exception {
        Map headers = exchange.getIn().getHeaders();
        Integer pos = null;
        if (headers.containsKey("CamelHazelcastObjectIndex")) {
            if (!(headers.get("CamelHazelcastObjectIndex") instanceof Integer)) {
                throw new IllegalArgumentException("OBJECT_POS Should be of type Integer");
            }
            pos = (Integer)headers.get("CamelHazelcastObjectIndex");
        }
        HazelcastOperation operation = this.lookupOperation(exchange);
        switch (operation) {
            case ADD: {
                this.add(pos, exchange);
                break;
            }
            case GET: {
                this.get(pos, exchange);
                break;
            }
            case SET_VALUE: {
                this.set(pos, exchange);
                break;
            }
            case REMOVE_VALUE: {
                this.remove(pos, exchange);
                break;
            }
            case CLEAR: {
                this.clear();
                break;
            }
            case ADD_ALL: {
                this.addAll(pos, exchange);
                break;
            }
            case REMOVE_ALL: {
                this.removeAll(exchange);
                break;
            }
            case RETAIN_ALL: {
                this.retainAll(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The value '%s' is not allowed for parameter '%s' on the LIST cache.", new Object[]{operation, "CamelHazelcastOperationType"}));
            }
        }
        HazelcastComponentHelper.copyHeaders(exchange);
    }

    private void add(Integer pos, Exchange exchange) {
        Object body = exchange.getIn().getBody();
        if (null == pos) {
            this.list.add(body);
        } else {
            this.list.add(pos.intValue(), body);
        }
    }

    private void get(Integer pos, Exchange exchange) {
        exchange.getMessage().setBody(this.list.get(pos.intValue()));
    }

    private void set(Integer pos, Exchange exchange) {
        if (null == pos) {
            throw new IllegalArgumentException("Empty position for set operation.");
        }
        Object body = exchange.getIn().getBody();
        this.list.set(pos.intValue(), body);
    }

    private void remove(Integer pos, Exchange exchange) {
        if (null == pos) {
            Object body = exchange.getIn().getBody();
            this.list.remove(body);
        } else {
            int position = pos;
            this.list.remove(position);
        }
    }

    private void clear() {
        this.list.clear();
    }

    private void addAll(Integer pos, Exchange exchange) {
        Object body = exchange.getIn().getBody();
        if (null == pos) {
            this.list.addAll((Collection)body);
        } else {
            this.list.addAll(pos.intValue(), (Collection)body);
        }
    }

    private void removeAll(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.list.removeAll((Collection)body);
    }

    private void retainAll(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.list.retainAll((Collection)body);
    }
}

