/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.topic;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.topic.ITopic;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.HazelcastDefaultProducer;
import org.apache.camel.component.hazelcast.HazelcastOperation;

public class HazelcastTopicProducer
extends HazelcastDefaultProducer {
    private ITopic<Object> topic;

    public HazelcastTopicProducer(HazelcastInstance hazelcastInstance, HazelcastDefaultEndpoint endpoint, String topicName, boolean reliable) {
        super(endpoint);
        this.topic = !reliable ? hazelcastInstance.getTopic(topicName) : hazelcastInstance.getReliableTopic(topicName);
    }

    public void process(Exchange exchange) throws Exception {
        HazelcastOperation operation = this.lookupOperation(exchange);
        switch (operation) {
            case PUBLISH: {
                this.publish(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The value '%s' is not allowed for parameter '%s' on the TOPIC cache.", new Object[]{operation, "CamelHazelcastOperationType"}));
            }
        }
        HazelcastComponentHelper.copyHeaders(exchange);
    }

    private void publish(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.topic.publish(body);
    }
}

