/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.topic;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.MessageListener;
import java.util.UUID;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.hazelcast.HazelcastDefaultConsumer;
import org.apache.camel.component.hazelcast.listener.CamelMessageListener;

public class HazelcastTopicConsumer
extends HazelcastDefaultConsumer {
    private ITopic<Object> topic;
    private UUID listener;

    public HazelcastTopicConsumer(HazelcastInstance hazelcastInstance, Endpoint endpoint, Processor processor, String cacheName, boolean reliable) {
        super(hazelcastInstance, endpoint, processor, cacheName);
        this.topic = !reliable ? hazelcastInstance.getTopic(cacheName) : hazelcastInstance.getReliableTopic(cacheName);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.listener = this.topic.addMessageListener((MessageListener)new CamelMessageListener(this, this.cacheName));
    }

    protected void doStop() throws Exception {
        this.topic.removeMessageListener(this.listener);
        super.doStop();
    }
}

