/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.hbase.HBaseAttribute;
import org.apache.camel.component.hbase.HBaseComponent;
import org.apache.camel.component.hbase.HBaseConsumer;
import org.apache.camel.component.hbase.HBaseDeleteHandler;
import org.apache.camel.component.hbase.HBaseProducer;
import org.apache.camel.component.hbase.HBaseRemoveHandler;
import org.apache.camel.component.hbase.mapping.CellMappingStrategyFactory;
import org.apache.camel.component.hbase.model.HBaseCell;
import org.apache.camel.component.hbase.model.HBaseRow;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.security.UserGroupInformation;

@UriEndpoint(firstVersion="2.10.0", scheme="hbase", title="HBase", syntax="hbase:tableName", category={Category.BIGDATA, Category.DATABASE, Category.HADOOP})
public class HBaseEndpoint
extends DefaultEndpoint {
    @UriPath(description="The name of the table")
    @Metadata(required=true)
    private final String tableName;
    private transient TableName tableNameObj;
    @UriParam(label="producer", defaultValue="100")
    private int maxResults = 100;
    @UriParam
    private List<Filter> filters;
    @UriParam(label="consumer", enums="CamelHBasePut,CamelHBaseGet,CamelHBaseScan,CamelHBaseDelete")
    private String operation;
    @UriParam(label="consumer", defaultValue="true")
    private boolean remove = true;
    @UriParam(enums="header,body")
    private String mappingStrategyName;
    @UriParam
    private String mappingStrategyClassName;
    @UriParam
    private CellMappingStrategyFactory cellMappingStrategyFactory = new CellMappingStrategyFactory();
    @UriParam(label="consumer")
    private HBaseRemoveHandler removeHandler = new HBaseDeleteHandler();
    @UriParam
    private HBaseRow rowModel;
    @UriParam(label="consumer")
    private int maxMessagesPerPoll;
    @UriParam
    private UserGroupInformation userGroupInformation;
    @UriParam(prefix="row.", multiValue=true)
    private Map<String, Object> rowMapping;

    public HBaseEndpoint(String uri, HBaseComponent component, String tableName) {
        super(uri, (Component)component);
        this.tableName = tableName;
        if (this.tableName == null) {
            throw new IllegalArgumentException("Table name can not be null");
        }
        this.tableNameObj = TableName.valueOf((String)tableName);
    }

    public Producer createProducer() throws Exception {
        return new HBaseProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        HBaseConsumer consumer = new HBaseConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        consumer.setMaxMessagesPerPoll(this.maxMessagesPerPoll);
        return consumer;
    }

    public HBaseComponent getComponent() {
        return (HBaseComponent)super.getComponent();
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public CellMappingStrategyFactory getCellMappingStrategyFactory() {
        return this.cellMappingStrategyFactory;
    }

    public void setCellMappingStrategyFactory(CellMappingStrategyFactory cellMappingStrategyFactory) {
        this.cellMappingStrategyFactory = cellMappingStrategyFactory;
    }

    public String getMappingStrategyName() {
        return this.mappingStrategyName;
    }

    public void setMappingStrategyName(String mappingStrategyName) {
        this.mappingStrategyName = mappingStrategyName;
    }

    public String getMappingStrategyClassName() {
        return this.mappingStrategyClassName;
    }

    public void setMappingStrategyClassName(String mappingStrategyClassName) {
        this.mappingStrategyClassName = mappingStrategyClassName;
    }

    public HBaseRow getRowModel() {
        return this.rowModel;
    }

    public void setRowModel(HBaseRow rowModel) {
        this.rowModel = rowModel;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public HBaseRemoveHandler getRemoveHandler() {
        return this.removeHandler;
    }

    public void setRemoveHandler(HBaseRemoveHandler removeHandler) {
        this.removeHandler = removeHandler;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public UserGroupInformation getUserGroupInformation() {
        return this.userGroupInformation;
    }

    public void setUserGroupInformation(UserGroupInformation userGroupInformation) {
        this.userGroupInformation = userGroupInformation;
    }

    public Map<String, Object> getRowMapping() {
        return this.rowMapping;
    }

    public void setRowMapping(Map<String, Object> rowMapping) {
        this.rowMapping = rowMapping;
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.rowModel == null && this.rowMapping != null) {
            this.rowModel = this.createRowModel(this.rowMapping);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public Table getTable() throws IOException {
        if (this.userGroupInformation != null) {
            return (Table)this.userGroupInformation.doAs((PrivilegedAction)new PrivilegedAction<Table>(){

                @Override
                public Table run() {
                    try {
                        return HBaseEndpoint.this.getComponent().getConnection().getTable(HBaseEndpoint.this.tableNameObj);
                    }
                    catch (IOException e) {
                        throw new RuntimeCamelException((Throwable)e);
                    }
                }
            });
        }
        return this.getComponent().getConnection().getTable(this.tableNameObj);
    }

    private HBaseRow createRowModel(Map<String, Object> parameters) {
        String rowType;
        HBaseRow rowModel = new HBaseRow();
        if (parameters.containsKey(HBaseAttribute.HBASE_ROW_TYPE.asOption()) && (rowType = String.valueOf(parameters.remove(HBaseAttribute.HBASE_ROW_TYPE.asOption()))) != null && !rowType.isEmpty()) {
            rowModel.setRowType(this.getCamelContext().getClassResolver().resolveClass(rowType));
        }
        int i = 1;
        while (parameters.get(HBaseAttribute.HBASE_FAMILY.asOption(i)) != null && parameters.get(HBaseAttribute.HBASE_QUALIFIER.asOption(i)) != null) {
            String valueType;
            HBaseCell cellModel = new HBaseCell();
            cellModel.setFamily(String.valueOf(parameters.remove(HBaseAttribute.HBASE_FAMILY.asOption(i))));
            cellModel.setQualifier(String.valueOf(parameters.remove(HBaseAttribute.HBASE_QUALIFIER.asOption(i))));
            cellModel.setValue(String.valueOf(parameters.remove(HBaseAttribute.HBASE_VALUE.asOption(i))));
            if (parameters.containsKey(HBaseAttribute.HBASE_VALUE_TYPE.asOption(i)) && (valueType = String.valueOf(parameters.remove(HBaseAttribute.HBASE_VALUE_TYPE.asOption(i)))) != null && !valueType.isEmpty()) {
                cellModel.setValueType(this.getCamelContext().getClassResolver().resolveClass(valueType));
            }
            rowModel.getCells().add(cellModel);
            ++i;
        }
        return rowModel;
    }
}

