/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase.mapping;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.component.hbase.mapping.BodyMappingStrategy;
import org.apache.camel.component.hbase.mapping.CellMappingStrategy;
import org.apache.camel.component.hbase.mapping.HeaderMappingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellMappingStrategyFactory {
    public static final String HEADER = "header";
    public static final String BODY = "body";
    private static final Logger LOG = LoggerFactory.getLogger(CellMappingStrategyFactory.class);
    private static final Map<String, CellMappingStrategy> DEFAULT_STRATEGIES = new HashMap<String, CellMappingStrategy>();

    public CellMappingStrategyFactory() {
        DEFAULT_STRATEGIES.put(HEADER, new HeaderMappingStrategy());
        DEFAULT_STRATEGIES.put(BODY, new BodyMappingStrategy());
    }

    public CellMappingStrategy getStrategy(Message message) {
        CellMappingStrategy strategy = null;
        if (message.getHeader("CamelMappingStrategy") != null) {
            strategy = DEFAULT_STRATEGIES.get(message.getHeader("CamelMappingStrategy", String.class));
        }
        if (strategy == null && message.getHeader("CamelMappingStrategyClassName") != null) {
            strategy = this.loadStrategyFromClassName((String)message.getHeader("CamelMappingStrategyClassName", String.class));
        }
        if (strategy != null) {
            return strategy;
        }
        return DEFAULT_STRATEGIES.get(HEADER);
    }

    private CellMappingStrategy loadStrategyFromClassName(String strategyClassName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                Class<?> clazz = classLoader.loadClass(strategyClassName);
                return (CellMappingStrategy)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                LOG.warn("Failed to load HBase cell mapping strategy from class {}.", (Object)strategyClassName);
            }
        }
        return null;
    }
}

