/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase;

import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.hbase.HBaseEndpoint;
import org.apache.camel.component.hbase.HBaseRemoveHandler;
import org.apache.camel.component.hbase.mapping.CellMappingStrategyFactory;
import org.apache.camel.component.hbase.model.HBaseRow;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.apache.hadoop.security.UserGroupInformation;

public class HBaseEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        HBaseEndpoint target = (HBaseEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)HBaseEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)HBaseEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "cellmappingstrategyfactory": 
            case "cellMappingStrategyFactory": {
                target.setCellMappingStrategyFactory((CellMappingStrategyFactory)HBaseEndpointConfigurer.property((CamelContext)camelContext, CellMappingStrategyFactory.class, (Object)value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler((ExceptionHandler)HBaseEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern((ExchangePattern)HBaseEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "filters": {
                target.setFilters((List)HBaseEndpointConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)HBaseEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "mappingstrategyclassname": 
            case "mappingStrategyClassName": {
                target.setMappingStrategyClassName((String)HBaseEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "mappingstrategyname": 
            case "mappingStrategyName": {
                target.setMappingStrategyName((String)HBaseEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "maxmessagesperpoll": 
            case "maxMessagesPerPoll": {
                target.setMaxMessagesPerPoll((Integer)HBaseEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxresults": 
            case "maxResults": {
                target.setMaxResults((Integer)HBaseEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                target.setOperation((String)HBaseEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "remove": {
                target.setRemove((Boolean)HBaseEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "removehandler": 
            case "removeHandler": {
                target.setRemoveHandler((HBaseRemoveHandler)HBaseEndpointConfigurer.property((CamelContext)camelContext, HBaseRemoveHandler.class, (Object)value));
                return true;
            }
            case "rowmapping": 
            case "rowMapping": {
                target.setRowMapping((Map)HBaseEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "rowmodel": 
            case "rowModel": {
                target.setRowModel((HBaseRow)HBaseEndpointConfigurer.property((CamelContext)camelContext, HBaseRow.class, (Object)value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous((Boolean)HBaseEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "usergroupinformation": 
            case "userGroupInformation": {
                target.setUserGroupInformation((UserGroupInformation)HBaseEndpointConfigurer.property((CamelContext)camelContext, UserGroupInformation.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        HBaseEndpoint target = (HBaseEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "cellmappingstrategyfactory": 
            case "cellMappingStrategyFactory": {
                return target.getCellMappingStrategyFactory();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "filters": {
                return target.getFilters();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "mappingstrategyclassname": 
            case "mappingStrategyClassName": {
                return target.getMappingStrategyClassName();
            }
            case "mappingstrategyname": 
            case "mappingStrategyName": {
                return target.getMappingStrategyName();
            }
            case "maxmessagesperpoll": 
            case "maxMessagesPerPoll": {
                return target.getMaxMessagesPerPoll();
            }
            case "maxresults": 
            case "maxResults": {
                return target.getMaxResults();
            }
            case "operation": {
                return target.getOperation();
            }
            case "remove": {
                return target.isRemove();
            }
            case "removehandler": 
            case "removeHandler": {
                return target.getRemoveHandler();
            }
            case "rowmapping": 
            case "rowMapping": {
                return target.getRowMapping();
            }
            case "rowmodel": 
            case "rowModel": {
                return target.getRowModel();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
            case "usergroupinformation": 
            case "userGroupInformation": {
                return target.getUserGroupInformation();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("tableName", String.class);
        map.put("cellMappingStrategyFactory", CellMappingStrategyFactory.class);
        map.put("filters", List.class);
        map.put("mappingStrategyClassName", String.class);
        map.put("mappingStrategyName", String.class);
        map.put("rowMapping", Map.class);
        map.put("rowModel", HBaseRow.class);
        map.put("userGroupInformation", UserGroupInformation.class);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("maxMessagesPerPoll", Integer.TYPE);
        map.put("operation", String.class);
        map.put("remove", Boolean.TYPE);
        map.put("removeHandler", HBaseRemoveHandler.class);
        map.put("exceptionHandler", ExceptionHandler.class);
        map.put("exchangePattern", ExchangePattern.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("maxResults", Integer.TYPE);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("synchronous", Boolean.TYPE);
        ALL_OPTIONS = map;
    }
}

