/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.ws.Holder;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.camel.component.hdfs.HdfsFileType;
import org.apache.camel.component.hdfs.HdfsHeader;
import org.apache.camel.component.hdfs.HdfsInfo;
import org.apache.camel.component.hdfs.HdfsInputStream;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public final class HdfsConsumer
extends ScheduledPollConsumer {
    private final HdfsConfiguration config;
    private final StringBuilder hdfsPath;
    private final Processor processor;
    private AtomicBoolean idle = new AtomicBoolean(false);
    private final ReadWriteLock rwlock = new ReentrantReadWriteLock();
    private HdfsInputStream istream;

    public HdfsConsumer(DefaultEndpoint endpoint, Processor processor, HdfsConfiguration config) {
        super((Endpoint)endpoint, processor);
        this.config = config;
        this.hdfsPath = config.getFileSystemType().getHdfsPath(config);
        this.processor = processor;
    }

    protected void doStart() throws Exception {
        super.setInitialDelay(this.config.getInitialDelay());
        super.setDelay(this.config.getDelay());
        super.setUseFixedDelay(false);
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int poll() throws Exception {
        FileStatus[] fileStatuses;
        int numMessages = 0;
        HdfsInfo info = new HdfsInfo(this.hdfsPath.toString());
        if (info.getFileSystem().isFile(info.getPath())) {
            fileStatuses = info.getFileSystem().globStatus(info.getPath());
        } else {
            Path pattern = info.getPath().suffix("/" + this.config.getPattern());
            class ExcludePathFilter
            implements PathFilter {
                ExcludePathFilter() {
                }

                public boolean accept(Path path) {
                    return !path.toString().endsWith(HdfsConsumer.this.config.getOpenedSuffix()) && !path.toString().endsWith(HdfsConsumer.this.config.getReadSuffix());
                }
            }
            fileStatuses = info.getFileSystem().globStatus(pattern, (PathFilter)new ExcludePathFilter());
        }
        if (fileStatuses.length > 0) {
            this.idle.set(false);
        }
        for (int i = 0; i < fileStatuses.length; ++i) {
            FileStatus status = fileStatuses[i];
            if (this.normalFileIsDirectoryNoSuccessFile(status, info)) continue;
            try {
                this.rwlock.writeLock().lock();
                this.istream = HdfsInputStream.createInputStream(fileStatuses[i].getPath().toString(), this.config);
            }
            finally {
                this.rwlock.writeLock().unlock();
            }
            Holder key = new Holder();
            Holder value = new Holder();
            while (this.istream.next((Holder<Object>)key, (Holder<Object>)value) != 0L) {
                Exchange exchange = this.getEndpoint().createExchange();
                DefaultMessage message = new DefaultMessage();
                message.setHeader("CamelFileName", (Object)StringUtils.substringAfterLast((String)status.getPath().toString(), (String)"/"));
                if (key.value != null) {
                    message.setHeader(HdfsHeader.KEY.name(), key.value);
                }
                message.setBody(value.value);
                exchange.setIn((Message)message);
                this.processor.process(exchange);
                ++numMessages;
            }
            this.istream.close();
        }
        this.idle.set(true);
        return numMessages;
    }

    private boolean normalFileIsDirectoryNoSuccessFile(FileStatus status, HdfsInfo info) throws IOException {
        if (this.config.getFileType().equals((Object)HdfsFileType.NORMAL_FILE) && status.isDir()) {
            Path successPath = new Path(status.getPath().toString() + "/_SUCCESS");
            if (!info.getFileSystem().exists(successPath)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HdfsInputStream getIstream() {
        try {
            this.rwlock.readLock().lock();
            HdfsInputStream hdfsInputStream = this.istream;
            return hdfsInputStream;
        }
        finally {
            this.rwlock.readLock().unlock();
        }
    }

    public AtomicBoolean isIdle() {
        return this.idle;
    }
}

