/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.hdfs.HdfsEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.hadoop.fs.FsUrlStreamHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsComponent.class);

    public HdfsComponent() {
        this.initHdfs();
    }

    public HdfsComponent(CamelContext context) {
        super(context);
        this.initHdfs();
    }

    protected final Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        HdfsEndpoint hdfsEndpoint = new HdfsEndpoint(uri, this.getCamelContext());
        this.setProperties(hdfsEndpoint.getConfig(), parameters);
        return hdfsEndpoint;
    }

    protected void initHdfs() {
        try {
            URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)new FsUrlStreamHandlerFactory());
        }
        catch (Throwable e) {
            LOG.debug("Cannot set URLStreamHandlerFactory due " + e.getMessage() + ". This exception will be ignored.", e);
        }
    }
}

