/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.hdfs.DefaultHdfsFile;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.camel.component.hdfs.HdfsFileSystemType;
import org.apache.camel.component.hdfs.HdfsInfo;
import org.apache.camel.component.hdfs.HdfsInfoFactory;
import org.apache.camel.component.hdfs.HdfsInputStream;
import org.apache.camel.component.hdfs.HdfsOutputStream;
import org.apache.camel.component.hdfs.Holder;
import org.apache.camel.util.IOHelper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HdfsNormalFileHandler
extends DefaultHdfsFile<OutputStream, InputStream> {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsNormalFileHandler.class);
    private boolean consumed;

    HdfsNormalFileHandler() {
    }

    @Override
    public OutputStream createOutputStream(String hdfsPath, HdfsInfoFactory hdfsInfoFactory) {
        try {
            HdfsInfo hdfsInfo = hdfsInfoFactory.newHdfsInfo(hdfsPath);
            HdfsConfiguration endpointConfig = hdfsInfoFactory.getEndpointConfig();
            FSDataOutputStream outputStream = endpointConfig.isAppend() ? hdfsInfo.getFileSystem().append(hdfsInfo.getPath(), endpointConfig.getBufferSize(), () -> {}) : hdfsInfo.getFileSystem().create(hdfsInfo.getPath(), endpointConfig.isOverwrite(), endpointConfig.getBufferSize(), endpointConfig.getReplication(), endpointConfig.getBlockSize(), () -> {});
            return outputStream;
        }
        catch (IOException ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    @Override
    public long append(HdfsOutputStream hdfsOutputStream, Object key, Object value, Exchange exchange) {
        long l;
        InputStream inputStream = null;
        try {
            inputStream = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, exchange, value);
            l = this.copyBytes(inputStream, (OutputStream)((FSDataOutputStream)hdfsOutputStream.getOut()), 4096, false);
        }
        catch (IOException ex) {
            try {
                throw new RuntimeCamelException((Throwable)ex);
            }
            catch (Throwable throwable) {
                IOHelper.close(inputStream);
                throw throwable;
            }
        }
        IOHelper.close((Closeable)inputStream);
        return l;
    }

    @Override
    public InputStream createInputStream(String hdfsPath, HdfsInfoFactory hdfsInfoFactory) {
        try {
            FileInputStream inputStream;
            HdfsConfiguration endpointConfig = hdfsInfoFactory.getEndpointConfig();
            if (endpointConfig.getFileSystemType().equals((Object)HdfsFileSystemType.LOCAL)) {
                HdfsInfo hdfsInfo = hdfsInfoFactory.newHdfsInfo(hdfsPath);
                inputStream = hdfsInfo.getFileSystem().open(hdfsInfo.getPath());
            } else {
                inputStream = new FileInputStream(this.getHdfsFileToTmpFile(hdfsPath, endpointConfig));
            }
            return inputStream;
        }
        catch (IOException ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    @Override
    public long next(HdfsInputStream hdfsInputStream, Holder<Object> key, Holder<Object> value) {
        if (hdfsInputStream.isStreamDownload()) {
            return this.nextAsWrappedStream(hdfsInputStream, key, value);
        }
        return this.nextAsOutputStream(hdfsInputStream, key, value);
    }

    private long nextAsWrappedStream(HdfsInputStream hdfsInputStream, Holder<Object> key, Holder<Object> value) {
        InputStream inputStream = (InputStream)hdfsInputStream.getIn();
        value.setValue(inputStream);
        if (this.consumed) {
            return 0L;
        }
        this.consumed = true;
        return 1L;
    }

    private long nextAsOutputStream(HdfsInputStream hdfsInputStream, Holder<Object> key, Holder<Object> value) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(hdfsInputStream.getChunkSize());
            byte[] buf = new byte[hdfsInputStream.getChunkSize()];
            int bytesRead = ((InputStream)hdfsInputStream.getIn()).read(buf);
            if (bytesRead >= 0) {
                outputStream.write(buf, 0, bytesRead);
                value.setValue(outputStream);
                return bytesRead;
            }
            value.setValue(outputStream);
            return 0L;
        }
        catch (IOException ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    private File getHdfsFileToTmpFile(String hdfsPath, HdfsConfiguration configuration) {
        try {
            boolean result;
            File outputDest;
            String fileName = hdfsPath.substring(hdfsPath.lastIndexOf(47));
            try {
                outputDest = Files.createTempFile(fileName, ".hdfs", new FileAttribute[0]).toFile();
            }
            catch (Exception ex) {
                outputDest = File.createTempFile(fileName, ".hdfs");
            }
            if (outputDest.exists() && !(result = outputDest.delete())) {
                LOG.error("Failed to delete output destination {}", (Object)outputDest);
            }
            HdfsInfoFactory hdfsInfoFactory = new HdfsInfoFactory(configuration);
            HdfsInfo hdfsInfo = hdfsInfoFactory.newHdfsInfo(hdfsPath);
            FileSystem fileSystem = hdfsInfo.getFileSystem();
            FileUtil.copy((FileSystem)fileSystem, (Path)new Path(hdfsPath), (File)outputDest, (boolean)false, (Configuration)fileSystem.getConf());
            try {
                FileUtil.copy((FileSystem)fileSystem, (Path)new Path(hdfsPath), (FileSystem)FileSystem.getLocal((Configuration)new Configuration()), (Path)new Path(outputDest.toURI()), (boolean)false, (Configuration)fileSystem.getConf());
            }
            catch (IOException e) {
                return outputDest;
            }
            return new File(outputDest, fileName);
        }
        catch (IOException ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }
}

