/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.Lz4Codec;
import org.apache.hadoop.io.compress.SnappyCodec;
import org.apache.hadoop.io.compress.ZStandardCodec;

public enum HdfsCompressionCodec {
    DEFAULT{

        @Override
        public CompressionCodec getCodec() {
            return new DefaultCodec();
        }
    }
    ,
    GZIP{

        @Override
        public CompressionCodec getCodec() {
            return new GzipCodec();
        }
    }
    ,
    BZIP2{

        @Override
        public CompressionCodec getCodec() {
            return new BZip2Codec();
        }
    }
    ,
    SNAPPY{

        @Override
        public CompressionCodec getCodec() {
            return new SnappyCodec();
        }
    }
    ,
    LZ4{

        @Override
        public CompressionCodec getCodec() {
            return new Lz4Codec();
        }
    }
    ,
    ZSTANDARD{

        @Override
        public CompressionCodec getCodec() {
            return new ZStandardCodec();
        }
    };


    public abstract CompressionCodec getCodec();
}

