/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.hdfs.Holder;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class HdfsWritableFactories {

    public static final class HdfsObjectWritableFactory
    implements HdfsWritableFactory {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Writable create(Object value, TypeConverter typeConverter, Holder<Integer> size) {
            try (InputStream is = (InputStream)typeConverter.convertTo(InputStream.class, value);){
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IOUtils.copyBytes((InputStream)is, (OutputStream)bos, (int)4096, (boolean)false);
                BytesWritable writable = new BytesWritable();
                writable.set(bos.toByteArray(), 0, bos.toByteArray().length);
                size.setValue(bos.toByteArray().length);
                BytesWritable bytesWritable = writable;
                return bytesWritable;
            }
            catch (IOException ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }

        @Override
        public Object read(Writable writable, Holder<Integer> size) {
            size.setValue(0);
            return null;
        }
    }

    public static final class HdfsTextWritableFactory
    implements HdfsWritableFactory {
        @Override
        public Writable create(Object value, TypeConverter typeConverter, Holder<Integer> size) {
            Text writable = new Text();
            writable.set((String)typeConverter.convertTo(String.class, value));
            size.setValue(writable.getBytes().length);
            return writable;
        }

        @Override
        public Object read(Writable writable, Holder<Integer> size) {
            size.setValue(((Text)writable).getLength());
            return writable.toString();
        }
    }

    public static final class HdfsLongWritableFactory
    implements HdfsWritableFactory {
        private static final int SIZE = 8;

        @Override
        public Writable create(Object value, TypeConverter typeConverter, Holder<Integer> size) {
            size.setValue(8);
            LongWritable writable = new LongWritable();
            writable.set(((Long)typeConverter.convertTo(Long.class, value)).longValue());
            return writable;
        }

        @Override
        public Object read(Writable writable, Holder<Integer> size) {
            size.setValue(8);
            return ((LongWritable)writable).get();
        }
    }

    public static final class HdfsIntWritableFactory
    implements HdfsWritableFactory {
        private static final int SIZE = 4;

        @Override
        public Writable create(Object value, TypeConverter typeConverter, Holder<Integer> size) {
            size.setValue(4);
            IntWritable writable = new IntWritable();
            writable.set(((Integer)typeConverter.convertTo(Integer.class, value)).intValue());
            return writable;
        }

        @Override
        public Object read(Writable writable, Holder<Integer> size) {
            size.setValue(4);
            return ((IntWritable)writable).get();
        }
    }

    public static final class HdfsFloatWritableFactory
    implements HdfsWritableFactory {
        private static final int SIZE = 4;

        @Override
        public Writable create(Object value, TypeConverter typeConverter, Holder<Integer> size) {
            size.setValue(4);
            FloatWritable writable = new FloatWritable();
            writable.set(((Float)typeConverter.convertTo(Float.class, value)).floatValue());
            return writable;
        }

        @Override
        public Object read(Writable writable, Holder<Integer> size) {
            size.setValue(4);
            return Float.valueOf(((FloatWritable)writable).get());
        }
    }

    public static final class HdfsDoubleWritableFactory
    implements HdfsWritableFactory {
        private static final int SIZE = 8;

        @Override
        public Writable create(Object value, TypeConverter typeConverter, Holder<Integer> size) {
            size.setValue(8);
            DoubleWritable writable = new DoubleWritable();
            writable.set(((Double)typeConverter.convertTo(Double.class, value)).doubleValue());
            return writable;
        }

        @Override
        public Object read(Writable writable, Holder<Integer> size) {
            size.setValue(8);
            return ((DoubleWritable)writable).get();
        }
    }

    public static final class HdfsBytesWritableFactory
    implements HdfsWritableFactory {
        @Override
        public Writable create(Object value, TypeConverter typeConverter, Holder<Integer> size) {
            BytesWritable writable = new BytesWritable();
            ByteBuffer bb = (ByteBuffer)value;
            writable.set(bb.array(), 0, bb.array().length);
            size.setValue(bb.array().length);
            return writable;
        }

        @Override
        public Object read(Writable writable, Holder<Integer> size) {
            size.setValue(((BytesWritable)writable).getLength());
            ByteBuffer bb = ByteBuffer.allocate(size.getValue());
            bb.put(((BytesWritable)writable).getBytes(), 0, size.getValue());
            return bb;
        }
    }

    public static final class HdfsBooleanWritableFactory
    implements HdfsWritableFactory {
        private static final int SIZE = 1;

        @Override
        public Writable create(Object value, TypeConverter typeConverter, Holder<Integer> size) {
            size.setValue(1);
            BooleanWritable writable = new BooleanWritable();
            writable.set(((Boolean)typeConverter.convertTo(Boolean.class, value)).booleanValue());
            return writable;
        }

        @Override
        public Object read(Writable writable, Holder<Integer> size) {
            size.setValue(1);
            return ((BooleanWritable)writable).get();
        }
    }

    public static final class HdfsByteWritableFactory
    implements HdfsWritableFactory {
        private static final int SIZE = 1;

        @Override
        public Writable create(Object value, TypeConverter typeConverter, Holder<Integer> size) {
            size.setValue(1);
            ByteWritable writable = new ByteWritable();
            writable.set(((Byte)typeConverter.convertTo(Byte.class, value)).byteValue());
            return writable;
        }

        @Override
        public Object read(Writable writable, Holder<Integer> size) {
            size.setValue(1);
            return ((ByteWritable)writable).get();
        }
    }

    public static final class HdfsNullWritableFactory
    implements HdfsWritableFactory {
        @Override
        public Writable create(Object value, TypeConverter typeConverter, Holder<Integer> size) {
            size.setValue(0);
            return NullWritable.get();
        }

        @Override
        public Object read(Writable writable, Holder<Integer> size) {
            size.setValue(0);
            return null;
        }
    }

    static interface HdfsWritableFactory {
        public Writable create(Object var1, TypeConverter var2, Holder<Integer> var3);

        public Object read(Writable var1, Holder<Integer> var2);
    }
}

