/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class HdfsEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":hostName:port/path";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "hdfs".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "hostName", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "port", 8020, false, copy);
        uri = this.buildPathParameter(syntax, uri, "path", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(50);
        props.add("checkIdleInterval");
        props.add("synchronous");
        props.add("compressionType");
        props.add("initialDelay");
        props.add("path");
        props.add("bridgeErrorHandler");
        props.add("valueType");
        props.add("greedy");
        props.add("kerberosKeytabLocation");
        props.add("maxMessagesPerPoll");
        props.add("scheduledExecutorService");
        props.add("overwrite");
        props.add("repeatCount");
        props.add("kerberosConfigFileLocation");
        props.add("connectOnStartup");
        props.add("sendEmptyMessageWhenIdle");
        props.add("schedulerProperties");
        props.add("namedNodes");
        props.add("kerberosUsername");
        props.add("blockSize");
        props.add("backoffIdleThreshold");
        props.add("lazyStartProducer");
        props.add("delay");
        props.add("port");
        props.add("startScheduler");
        props.add("splitStrategy");
        props.add("exceptionHandler");
        props.add("readSuffix");
        props.add("basicPropertyBinding");
        props.add("backoffMultiplier");
        props.add("hostName");
        props.add("pattern");
        props.add("fileSystemType");
        props.add("scheduler");
        props.add("useFixedDelay");
        props.add("runLoggingLevel");
        props.add("backoffErrorThreshold");
        props.add("keyType");
        props.add("timeUnit");
        props.add("owner");
        props.add("replication");
        props.add("chunkSize");
        props.add("openedSuffix");
        props.add("exchangePattern");
        props.add("streamDownload");
        props.add("pollStrategy");
        props.add("compressionCodec");
        props.add("fileType");
        props.add("append");
        props.add("bufferSize");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

