/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Map;
import org.apache.camel.ServiceStatus;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.spi.annotations.HealthCheck;

@HealthCheck(value="context-check")
public final class ContextHealthCheck
extends AbstractHealthCheck {
    public ContextHealthCheck() {
        super("camel", "context");
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public boolean isLiveness() {
        return true;
    }

    @Override
    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        builder.unknown();
        if (this.getCamelContext() != null) {
            ServiceStatus status = this.getCamelContext().getStatus();
            byte phase = this.getCamelContext().getCamelContextExtension().getStatusPhase();
            String name = this.getCamelContext().getName();
            builder.detail("context.name", (Object)name);
            builder.detail("context.version", (Object)this.getCamelContext().getVersion());
            builder.detail("context.status", (Object)status);
            builder.detail("context.phase", (Object)phase);
            switch (status) {
                case Initializing: 
                case Initialized: 
                case Starting: {
                    builder.message("Camel Context '" + name + "' is starting. Status: '" + String.valueOf(status) + "', Phase: '" + phase + "'. Please wait...");
                    builder.down();
                    break;
                }
                case Started: {
                    builder.up();
                    break;
                }
                case Stopping: 
                case Stopped: 
                case Suspending: 
                case Suspended: {
                    builder.message("Camel Context '" + name + "' is shutting down. Status: '" + String.valueOf(status) + "', Phase: '" + phase + "'. Please check the debug log");
                    builder.down();
                    break;
                }
                default: {
                    builder.message("Camel Context '" + name + "' has unknown Status: " + String.valueOf(status));
                    builder.down();
                }
            }
        }
    }
}

