/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import ca.uhn.hl7v2.parser.UnexpectedSegmentBehaviourEnum;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.hl7.HL7Charset;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceSupport;

@Dataformat(value="hl7")
public class HL7DataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private static final Map<String, String> HEADER_MAP = new HashMap<String, String>();
    private HapiContext hapiContext;
    private Parser parser;
    private boolean validate = true;

    public String getDataFormatName() {
        return "hl7";
    }

    public void marshal(Exchange exchange, Object body, OutputStream outputStream) throws Exception {
        Message message = (Message)ExchangeHelper.convertToMandatoryType((Exchange)exchange, Message.class, (Object)body);
        String charsetName = HL7Charset.getCharsetName(message, exchange);
        String encoded = this.parser.encode(message);
        outputStream.write(encoded.getBytes(charsetName));
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        byte[] body = (byte[])ExchangeHelper.convertToMandatoryType((Exchange)exchange, byte[].class, (Object)inputStream);
        String charsetName = HL7Charset.getCharsetName(body, this.guessCharsetName(body, exchange));
        String bodyAsString = new String(body, charsetName);
        Message message = this.parser.parse(bodyAsString);
        Terser terser = new Terser(message);
        for (Map.Entry<String, String> entry : HEADER_MAP.entrySet()) {
            exchange.getOut().setHeader(entry.getKey(), (Object)terser.get(entry.getValue()));
        }
        exchange.getOut().setHeader("CamelHL7Context", (Object)this.hapiContext);
        exchange.getOut().setHeader("CamelCharsetName", (Object)charsetName);
        return message;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public HapiContext getHapiContext() {
        return this.hapiContext;
    }

    public void setHapiContext(HapiContext context) {
        this.hapiContext = context;
    }

    public Parser getParser() {
        return this.parser;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    protected void doStart() throws Exception {
        if (this.hapiContext == null) {
            ParserConfiguration parserConfiguration;
            ValidationContext validationContext = this.validate ? ValidationContextFactory.defaultValidation() : ValidationContextFactory.noValidation();
            if (this.parser == null) {
                parserConfiguration = new ParserConfiguration();
                parserConfiguration.setDefaultObx2Type("ST");
                parserConfiguration.setInvalidObx2Type("ST");
                parserConfiguration.setUnexpectedSegmentBehaviour(UnexpectedSegmentBehaviourEnum.ADD_INLINE);
            } else {
                parserConfiguration = this.parser.getParserConfiguration();
            }
            this.hapiContext = new DefaultHapiContext(parserConfiguration, validationContext, (ModelClassFactory)new DefaultModelClassFactory());
        }
        if (this.parser == null) {
            this.parser = this.hapiContext.getGenericParser();
        }
    }

    protected void doStop() throws Exception {
    }

    protected String guessCharsetName(byte[] b, Exchange exchange) {
        return ExchangeHelper.getCharsetName((Exchange)exchange);
    }

    static {
        HEADER_MAP.put("CamelHL7SendingApplication", "MSH-3");
        HEADER_MAP.put("CamelHL7SendingFacility", "MSH-4");
        HEADER_MAP.put("CamelHL7ReceivingApplication", "MSH-5");
        HEADER_MAP.put("CamelHL7ReceivingFacility", "MSH-6");
        HEADER_MAP.put("CamelHL7Timestamp", "MSH-7");
        HEADER_MAP.put("CamelHL7Security", "MSH-8");
        HEADER_MAP.put("CamelHL7MessageType", "MSH-9-1");
        HEADER_MAP.put("CamelHL7TriggerEvent", "MSH-9-2");
        HEADER_MAP.put("CamelHL7MessageControl", "MSH-10");
        HEADER_MAP.put("CamelHL7ProcessingId", "MSH-11");
        HEADER_MAP.put("CamelHL7VersionId", "MSH-12");
        HEADER_MAP.put("CamelHL7Charset", "MSH-18");
    }
}

