/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.model.Message;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.camel.StreamCache;
import org.apache.camel.component.hl7.HL7MLLPConfig;

class HL7MLLPNettyEncoder
extends MessageToByteEncoder<Object> {
    private final HL7MLLPConfig config;

    HL7MLLPNettyEncoder() {
        this(new HL7MLLPConfig());
    }

    HL7MLLPNettyEncoder(HL7MLLPConfig config) {
        this.config = config;
    }

    protected void encode(ChannelHandlerContext channelHandlerContext, Object message, ByteBuf byteBuf) throws Exception {
        byte[] body;
        if (message == null) {
            throw new IllegalArgumentException("Message to be encoded is null");
        }
        if (message instanceof Exception) {
            throw (Exception)message;
        }
        if (message instanceof StreamCache) {
            StreamCache sc = (StreamCache)message;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            sc.writeTo((OutputStream)bos);
            body = bos.toByteArray();
        } else if (message instanceof Message) {
            body = ((Message)message).encode().getBytes(this.config.getCharset());
        } else if (message instanceof String) {
            body = ((String)message).getBytes(this.config.getCharset());
        } else if (message instanceof byte[]) {
            body = (byte[])message;
        } else {
            throw new IllegalArgumentException("The message to encode is not a supported type: " + message.getClass().getCanonicalName());
        }
        byteBuf.writeByte((int)this.config.getStartByte());
        byteBuf.writeBytes(body);
        byteBuf.writeByte((int)this.config.getEndByte1());
        byteBuf.writeByte((int)this.config.getEndByte2());
    }
}

