package org.apache.camel.http.common;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

@SuppressWarnings("unchecked")
public class HttpConverterLoader implements TypeConverterLoader {


    static abstract class BaseTypeConverter extends TypeConverterSupport {
        private final boolean allowNull;

        public BaseTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        @Override
        public boolean allowNull() {
            return allowNull;
        }

        @Override
        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T) doConvert(exchange, value);
            } catch (TypeConversionException e) {
                throw e;
            } catch (Exception e) {
                throw new TypeConversionException(value, type, e);
            }
        }
        protected abstract Object doConvert(Exchange exchange, Object value) throws Exception;
    };

    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap<>(6);

    public HttpConverterLoader() {
    }

    private void registerConverters() {
        converters.put(java.io.BufferedReader.class, org.apache.camel.http.common.HttpMessage.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.http.common.HttpConverter.toReader((org.apache.camel.http.common.HttpMessage) value);
            }
        });
        converters.put(java.io.InputStream.class, javax.servlet.http.HttpServletRequest.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.http.common.HttpConverter.toInputStream((javax.servlet.http.HttpServletRequest) value, exchange);
            }
        });
        converters.put(java.io.InputStream.class, org.apache.camel.http.common.HttpMessage.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.http.common.HttpConverter.toInputStream((org.apache.camel.http.common.HttpMessage) value, exchange);
            }
        });
        converters.put(javax.servlet.ServletInputStream.class, org.apache.camel.http.common.HttpMessage.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.http.common.HttpConverter.toServletInputStream((org.apache.camel.http.common.HttpMessage) value);
            }
        });
        converters.put(javax.servlet.http.HttpServletRequest.class, org.apache.camel.Message.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.http.common.HttpConverter.toServletRequest((org.apache.camel.Message) value);
            }
        });
        converters.put(javax.servlet.http.HttpServletResponse.class, org.apache.camel.Message.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.http.common.HttpConverter.toServletResponse((org.apache.camel.Message) value);
            }
        });
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registerConverters();
        converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, c));
    }

}
