/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.component.http.SSLContextParametersSecureProtocolSocketFactory;
import org.apache.camel.component.http.springboot.HttpComponentAutoConfiguration;
import org.apache.camel.component.http.springboot.HttpComponentConfiguration;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={HttpComponentAutoConfiguration.class})
@AutoConfigureAfter(value={HttpComponentAutoConfiguration.class})
public class HttpComponentSSLAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(HttpComponentSSLAutoConfiguration.class);

    @Bean
    public static HttpSSLPostProcessor cacheAutoConfigurationValidatorPostProcessor(CamelContext context, HttpComponentConfiguration config) {
        return new HttpSSLPostProcessor(context, config);
    }

    private void dummy() {
    }

    static class HttpSSLPostProcessor
    implements BeanFactoryPostProcessor {
        private CamelContext context;
        private HttpComponentConfiguration config;

        HttpSSLPostProcessor(CamelContext context, HttpComponentConfiguration config) {
            this.context = context;
            this.config = config;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            try {
                SSLContextParameters globalSSLParams;
                if (this.config != null && this.config.getUseGlobalSslContextParameters() != null && this.config.getUseGlobalSslContextParameters().booleanValue() && (globalSSLParams = this.context.getSSLContextParameters()) != null) {
                    SSLContextParametersSecureProtocolSocketFactory factory = new SSLContextParametersSecureProtocolSocketFactory(globalSSLParams, this.context);
                    Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)factory, 443));
                }
            }
            catch (NoUniqueBeanDefinitionException e) {
                LOG.warn("Multiple instance of SSLContextParameters found, skipping configuration");
            }
            catch (NoSuchBeanDefinitionException e) {
                LOG.debug("No instance of SSLContextParameters found");
            }
            catch (BeansException e) {
                LOG.warn("Cannot create SSLContextParameters", (Throwable)e);
            }
        }
    }
}

