/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpExchange;
import org.apache.camel.impl.PollingConsumerSupport;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPollingConsumer
extends PollingConsumerSupport<HttpExchange> {
    private final HttpEndpoint endpoint;
    private HttpClient httpClient;

    public HttpPollingConsumer(HttpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.httpClient = endpoint.createHttpClient();
    }

    public HttpExchange receive() {
        return this.receiveNoWait();
    }

    public HttpExchange receive(long timeout) {
        return this.receiveNoWait();
    }

    public HttpExchange receiveNoWait() {
        try {
            Header[] headers;
            HttpExchange exchange = (HttpExchange)this.endpoint.createExchange();
            HttpMethod method = this.createMethod();
            int responseCode = this.httpClient.executeMethod(method);
            byte[] responseBody = method.getResponseBody();
            Message message = exchange.getIn();
            message.setBody((Object)responseBody);
            for (Header header : headers = method.getResponseHeaders()) {
                String name = header.getName();
                String value = header.getValue();
                message.setHeader(name, (Object)value);
            }
            message.setHeader("http.responseCode", (Object)responseCode);
            return exchange;
        }
        catch (IOException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected HttpMethod createMethod() {
        String uri = this.endpoint.getEndpointUri();
        return new GetMethod(uri);
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

