/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Message;
import org.apache.camel.component.http.HttpExchange;
import org.apache.camel.component.http.HttpHeaderFilterStrategy;
import org.apache.camel.component.http.HttpMessage;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpBinding {
    @Deprecated
    public static final Set<String> DEFAULT_HEADERS_TO_IGNORE = new HashSet<String>(Arrays.asList("content-length", "content-type", "http.responseCode".toLowerCase()));
    private boolean useReaderForPayload;
    private HeaderFilterStrategy headerFilterStrategy = new HttpHeaderFilterStrategy();

    public HttpBinding(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResponse(HttpExchange exchange, HttpServletResponse response) throws IOException {
        Message out = exchange.getOut();
        if (out != null) {
            if (out.getHeader("http.responseCode") != null) {
                int code = (Integer)out.getHeader("http.responseCode", Integer.class);
                response.setStatus(code);
            }
            for (String key : out.getHeaders().keySet()) {
                String value = (String)out.getHeader(key, String.class);
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)value)) continue;
                response.setHeader(key, value);
            }
            if (out.getBody() != null) {
                InputStream is = (InputStream)out.getBody(InputStream.class);
                if (is != null) {
                    ServletOutputStream os = null;
                    try {
                        int c;
                        os = response.getOutputStream();
                        while ((c = is.read()) >= 0) {
                            os.write(c);
                        }
                        os.flush();
                    }
                    finally {
                        os.close();
                        is.close();
                    }
                } else {
                    String data = (String)out.getBody(String.class);
                    if (data != null) {
                        response.getWriter().print(data);
                    }
                }
            }
        }
    }

    public Object parseBody(HttpMessage httpMessage) throws IOException {
        HttpServletRequest request = httpMessage.getRequest();
        if (this.isUseReaderForPayload()) {
            return request.getReader();
        }
        return request.getInputStream();
    }

    public boolean shouldHeaderBePropagated(String headerName, String headerValue) {
        if (headerValue == null) {
            return false;
        }
        return this.headerFilterStrategy != null && !this.headerFilterStrategy.applyFilterToCamelHeaders(headerName, (Object)headerValue);
    }

    @Deprecated
    public void setIgnoredHeaders(Set<String> headersToIgnore) {
        if (this.headerFilterStrategy instanceof DefaultHeaderFilterStrategy) {
            ((DefaultHeaderFilterStrategy)this.headerFilterStrategy).setOutFilter(headersToIgnore);
        }
    }

    @Deprecated
    public Set<String> getIgnoredHeaders() {
        if (this.headerFilterStrategy instanceof DefaultHeaderFilterStrategy) {
            return ((DefaultHeaderFilterStrategy)this.headerFilterStrategy).getOutFilter();
        }
        return null;
    }

    public boolean isUseReaderForPayload() {
        return this.useReaderForPayload;
    }

    public void setUseReaderForPayload(boolean useReaderForPayload) {
        this.useReaderForPayload = useReaderForPayload;
    }
}

