/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import org.apache.camel.CamelException;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.httpclient.StatusLine;

public class HttpOperationFailedException
extends CamelException {
    private final String redirectLocation;
    private final int statusCode;
    private final StatusLine statusLine;

    public HttpOperationFailedException(int statusCode, StatusLine statusLine, String location) {
        super("HTTP operation failed with statusCode: " + statusCode + ", status: " + statusLine + (location != null ? ", redirectLocation: " + location : ""));
        this.statusCode = statusCode;
        this.statusLine = statusLine;
        this.redirectLocation = location;
    }

    public HttpOperationFailedException(int statusCode, StatusLine statusLine) {
        this(statusCode, statusLine, null);
    }

    public boolean isRedirectError() {
        return this.statusCode >= 300 && this.statusCode < 400;
    }

    public boolean hasRedirectLocation() {
        return ObjectHelper.isNotNullAndNonEmpty((String)this.redirectLocation);
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public int getStatusCode() {
        return this.statusCode;
    }
}

