/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.camel.Converter;
import org.apache.camel.component.http.HttpMessage;
import org.apache.camel.component.http.helper.GZIPHelper;

@Converter
public final class HttpConverter {
    private HttpConverter() {
    }

    @Converter
    public static HttpServletRequest toServletRequest(HttpMessage message) {
        if (message == null) {
            return null;
        }
        return message.getRequest();
    }

    @Converter
    public static ServletInputStream toServletInputStream(HttpMessage message) throws IOException {
        HttpServletRequest request = HttpConverter.toServletRequest(message);
        if (request != null) {
            return request.getInputStream();
        }
        return null;
    }

    @Converter
    public static InputStream toInputStream(HttpMessage message) throws Exception {
        return HttpConverter.toInputStream(HttpConverter.toServletRequest(message));
    }

    @Converter
    public static BufferedReader toReader(HttpMessage message) throws IOException {
        HttpServletRequest request = HttpConverter.toServletRequest(message);
        if (request != null) {
            return request.getReader();
        }
        return null;
    }

    @Converter
    public static InputStream toInputStream(HttpServletRequest request) throws IOException {
        if (request == null) {
            return null;
        }
        String contentEncoding = request.getHeader("Content-Encoding");
        return GZIPHelper.uncompressGzip(contentEncoding, (InputStream)request.getInputStream());
    }
}

