/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

public class ProxyHttpClientConfigurer
implements HttpClientConfigurer {
    private final String host;
    private final Integer port;
    private final String username;
    private final String password;
    private final String domain;
    private final String ntHost;

    public ProxyHttpClientConfigurer(String host, Integer port) {
        this(host, port, null, null, null, null);
    }

    public ProxyHttpClientConfigurer(String host, Integer port, String username, String password, String domain, String ntHost) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.domain = domain;
        this.ntHost = ntHost;
    }

    public void configureHttpClient(HttpClient client) {
        client.getHostConfiguration().setProxy(this.host, this.port.intValue());
        if (this.username != null && this.password != null) {
            Object defaultcreds = this.domain != null ? new NTCredentials(this.username, this.password, this.ntHost, this.domain) : new UsernamePasswordCredentials(this.username, this.password);
            client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)defaultcreds);
        }
    }
}

