/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.http.helper.GZIPHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;

@Converter
public class RequestEntityConverter {
    @Converter
    public RequestEntity toRequestEntity(ByteBuffer buffer, Exchange exchange) throws Exception {
        return this.asRequestEntity(buffer.array(), exchange);
    }

    @Converter
    public RequestEntity toRequestEntity(byte[] data, Exchange exchange) throws Exception {
        return this.asRequestEntity(data, exchange);
    }

    @Converter
    public RequestEntity toRequestEntity(InputStream inStream, Exchange exchange) throws Exception {
        return this.asRequestEntity(inStream, exchange);
    }

    @Converter
    public RequestEntity toRequestEntity(String str, Exchange exchange) throws Exception {
        if (GZIPHelper.isGzip(exchange.getIn())) {
            byte[] data = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, (Object)str);
            return this.asRequestEntity(data, exchange);
        }
        return null;
    }

    private RequestEntity asRequestEntity(InputStream in, Exchange exchange) throws IOException {
        return new InputStreamRequestEntity(GZIPHelper.compressGzip((String)exchange.getIn().getHeader("Content-Encoding", String.class), in), ExchangeHelper.getContentType((Exchange)exchange));
    }

    private RequestEntity asRequestEntity(byte[] data, Exchange exchange) throws Exception {
        return new InputStreamRequestEntity(GZIPHelper.compressGzip((String)exchange.getIn().getHeader("Content-Encoding", String.class), data), ExchangeHelper.getContentType((Exchange)exchange));
    }
}

