/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Message;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public final class GZIPHelper {
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String GZIP = "gzip";

    private GZIPHelper() {
    }

    public static void setGZIPMessageHeader(Message message) {
        message.setHeader(CONTENT_ENCODING, (Object)GZIP);
    }

    public static void setGZIPContentEncoding(HttpServletResponse response) {
        response.setHeader(CONTENT_ENCODING, GZIP);
    }

    public static InputStream uncompressGzip(String contentEncoding, InputStream in) throws IOException {
        if (GZIPHelper.isGzip(contentEncoding)) {
            return new GZIPInputStream(in);
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream compressGzip(String contentEncoding, InputStream in) throws IOException {
        if (GZIPHelper.isGzip(contentEncoding)) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(os);
            try {
                IOHelper.copy((InputStream)in, (OutputStream)gzip);
                gzip.finish();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
                return byteArrayInputStream;
            }
            finally {
                ObjectHelper.close((Closeable)gzip, (String)GZIP, null);
                ObjectHelper.close((Closeable)os, (String)"byte array output stream", null);
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream compressGzip(String contentEncoding, byte[] data) throws IOException {
        if (GZIPHelper.isGzip(contentEncoding)) {
            ByteArrayInputStream byteArrayInputStream;
            ByteArrayOutputStream os = null;
            GZIPOutputStream gzip = null;
            try {
                os = new ByteArrayOutputStream();
                gzip = new GZIPOutputStream(os);
                gzip.write(data);
                gzip.finish();
                byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
            }
            catch (Throwable throwable) {
                ObjectHelper.close(gzip, (String)GZIP, null);
                ObjectHelper.close((Closeable)os, (String)"byte array", null);
                throw throwable;
            }
            ObjectHelper.close((Closeable)gzip, (String)GZIP, null);
            ObjectHelper.close((Closeable)os, (String)"byte array", null);
            return byteArrayInputStream;
        }
        return new ByteArrayInputStream(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressGZIP(byte[] data) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(os);
        try {
            gzip.write(data);
            gzip.finish();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            gzip.close();
            os.close();
        }
    }

    public static boolean isGzip(Message message) {
        return GZIPHelper.isGzip((String)message.getHeader(CONTENT_ENCODING, String.class));
    }

    public static boolean isGzip(String header) {
        return header != null && header.toLowerCase().contains(GZIP);
    }

    public static boolean containsGzip(String str) {
        return str != null && str.toLowerCase().indexOf(GZIP) >= 0;
    }
}

