/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.http.helper.GZIPHelper;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;

@Converter
public class RequestEntityConverter {
    @Converter
    public RequestEntity toRequestEntity(ByteBuffer buffer, Exchange exchange) throws Exception {
        return new InputStreamRequestEntity(GZIPHelper.toGZIPInputStreamIfRequested((String)exchange.getIn().getHeader("Content-Encoding", String.class), buffer.array()));
    }

    @Converter
    public RequestEntity toRequestEntity(byte[] array, Exchange exchange) throws Exception {
        return new InputStreamRequestEntity(GZIPHelper.toGZIPInputStreamIfRequested((String)exchange.getIn().getHeader("Content-Encoding", String.class), array));
    }

    @Converter
    public RequestEntity toRequestEntity(InputStream inStream, Exchange exchange) throws Exception {
        return new InputStreamRequestEntity(GZIPHelper.getGZIPWrappedInputStream((String)exchange.getIn().getHeader("Content-Encoding", String.class), inStream));
    }

    @Converter
    public RequestEntity toRequestEntity(String str, Exchange exchange) throws Exception {
        return new InputStreamRequestEntity(GZIPHelper.toGZIPInputStreamIfRequested((String)exchange.getIn().getHeader("Content-Encoding", String.class), str.getBytes()));
    }
}

