/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpExchange;
import org.apache.camel.component.http.helper.LoadingByteArrayOutputStream;
import org.apache.camel.impl.PollingConsumerSupport;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;

public class HttpPollingConsumer
extends PollingConsumerSupport {
    private final HttpEndpoint endpoint;
    private HttpClient httpClient;

    public HttpPollingConsumer(HttpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.httpClient = endpoint.createHttpClient();
    }

    public Exchange receive() {
        return this.receiveNoWait();
    }

    public Exchange receive(long timeout) {
        return this.receiveNoWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange receiveNoWait() {
        HttpExchange exchange = (HttpExchange)this.endpoint.createExchange();
        HttpMethod method = this.createMethod();
        try {
            int responseCode = this.httpClient.executeMethod(method);
            LoadingByteArrayOutputStream bos = new LoadingByteArrayOutputStream();
            InputStream is = method.getResponseBodyAsStream();
            try {
                IOUtils.copy((InputStream)is, (OutputStream)bos);
                bos.flush();
            }
            finally {
                is.close();
            }
            Message message = exchange.getIn();
            message.setBody((Object)bos.createInputStream());
            Header[] headers = method.getResponseHeaders();
            HeaderFilterStrategy strategy = this.endpoint.getHeaderFilterStrategy();
            for (Header header : headers) {
                String name = header.getName();
                String value = header.getValue();
                if (strategy == null || strategy.applyFilterToExternalHeaders(name, (Object)value, (Exchange)exchange)) continue;
                message.setHeader(name, (Object)value);
            }
            message.setHeader("CamelHttpResponseCode", (Object)responseCode);
            HttpExchange httpExchange = exchange;
            return httpExchange;
        }
        catch (IOException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected HttpMethod createMethod() {
        String uri = this.endpoint.getEndpointUri();
        return new GetMethod(uri);
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

