/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.camel.Message;
import org.apache.camel.util.ObjectHelper;

public final class GZIPHelper {
    private GZIPHelper() {
    }

    public static InputStream toGZIPInputStream(String contentEncoding, InputStream in) throws IOException {
        if (GZIPHelper.isGzip(contentEncoding)) {
            return new GZIPInputStream(in);
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream toGZIPInputStream(String contentEncoding, byte[] data) throws Exception {
        if (GZIPHelper.isGzip(contentEncoding)) {
            ByteArrayInputStream byteArrayInputStream;
            ByteArrayOutputStream os = null;
            GZIPOutputStream gzip = null;
            try {
                os = new ByteArrayOutputStream();
                gzip = new GZIPOutputStream(os);
                gzip.write(data);
                gzip.finish();
                byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
            }
            catch (Throwable throwable) {
                ObjectHelper.close(gzip, (String)"gzip", null);
                ObjectHelper.close((Closeable)os, (String)"byte array", null);
                throw throwable;
            }
            ObjectHelper.close((Closeable)gzip, (String)"gzip", null);
            ObjectHelper.close((Closeable)os, (String)"byte array", null);
            return byteArrayInputStream;
        }
        return new ByteArrayInputStream(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressGZIP(byte[] data) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(os);
        try {
            gzip.write(data);
            gzip.finish();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            gzip.close();
            os.close();
        }
    }

    public static boolean isGzip(Message message) {
        return GZIPHelper.isGzip((String)message.getHeader("Content-Encoding", String.class));
    }

    public static boolean isGzip(String header) {
        return header != null && header.toLowerCase().contains("gzip");
    }
}

