/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpConverter;
import org.apache.camel.component.http.HttpHeaderFilterStrategy;
import org.apache.camel.component.http.HttpMessage;
import org.apache.camel.component.http.helper.GZIPHelper;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;

public class DefaultHttpBinding
implements HttpBinding {
    private boolean useReaderForPayload;
    private HeaderFilterStrategy headerFilterStrategy = new HttpHeaderFilterStrategy();

    public DefaultHttpBinding() {
    }

    public DefaultHttpBinding(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public void readRequest(HttpServletRequest request, HttpMessage message) {
        Map parameterMap = request.getParameterMap();
        message.getBody();
        Map headers = message.getHeaders();
        String contentType = "";
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = request.getHeader(name);
            if (name.toLowerCase().equals("content-type")) {
                name = "Content-Type";
                contentType = value;
            }
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, message.getExchange())) continue;
            headers.put(name, value);
        }
        String method = request.getMethod();
        if (method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("POST") && contentType.equalsIgnoreCase("application/x-www-form-urlencoded")) {
            names = request.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = request.getParameter(name);
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, message.getExchange())) continue;
                headers.put(name, value);
            }
        }
        headers.put("CamelHttpMethod", request.getMethod());
        headers.put("CamelHttpQuery", request.getQueryString());
        headers.put("CamelHttpUrl", request.getRequestURL());
        headers.put("CamelHttpUri", request.getRequestURI());
        headers.put("CamelHttpPath", request.getPathInfo());
        headers.put("Content-Type", request.getContentType());
        headers.put("CamelHttpCharacterEncoding", request.getCharacterEncoding());
    }

    public void writeResponse(Exchange exchange, HttpServletResponse response) throws IOException {
        if (exchange.isFailed()) {
            if (exchange.hasFault()) {
                this.doWriteFaultResponse(exchange.getFault(), response, exchange);
            } else {
                this.doWriteExceptionResponse(exchange.getException(), response);
            }
        } else {
            this.copyProtocolHeaders(exchange.getIn(), exchange.getOut());
            Message out = exchange.getOut();
            if (out != null) {
                this.doWriteResponse(out, response, exchange);
            }
        }
    }

    private void copyProtocolHeaders(Message request, Message response) {
        if (request.getHeader("Content-Encoding") != null) {
            String contentEncoding = (String)request.getHeader("Content-Encoding", String.class);
            response.setHeader("Content-Encoding", (Object)contentEncoding);
        }
    }

    public void doWriteExceptionResponse(Throwable exception, HttpServletResponse response) throws IOException {
        response.setStatus(500);
        response.setContentType("text/plain");
        PrintWriter pw = response.getWriter();
        exception.printStackTrace(pw);
        pw.flush();
    }

    public void doWriteFaultResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        this.doWriteResponse(message, response, exchange);
    }

    public void doWriteResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        if (message.getHeader("CamelHttpResponseCode") != null) {
            int code = (Integer)message.getHeader("CamelHttpResponseCode", Integer.class);
            response.setStatus(code);
        }
        String contentType = MessageHelper.getContentType((Message)message);
        if (MessageHelper.getContentType((Message)message) != null) {
            response.setContentType(contentType);
        }
        for (String key : message.getHeaders().keySet()) {
            String value = (String)message.getHeader(key, String.class);
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)value, exchange)) continue;
            response.setHeader(key, value);
        }
        if (message.getBody() != null) {
            if (GZIPHelper.isGzip(message)) {
                this.doWriteGZIPResponse(message, response, exchange);
            } else {
                this.doWriteDirectResponse(message, response, exchange);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteDirectResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        InputStream is = (InputStream)message.getBody(InputStream.class);
        if (is != null) {
            ServletOutputStream os = response.getOutputStream();
            try {
                IOHelper.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                os.close();
                is.close();
            }
        } else {
            String data = (String)message.getBody(String.class);
            if (data != null) {
                response.setContentLength(data.length());
                response.getWriter().print(data);
                response.getWriter().flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteGZIPResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        byte[] bytes;
        try {
            bytes = (byte[])message.getMandatoryBody(byte[].class);
        }
        catch (InvalidPayloadException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        byte[] data = GZIPHelper.compressGZIP(bytes);
        ServletOutputStream os = response.getOutputStream();
        try {
            response.setContentLength(data.length);
            os.write(data);
            os.flush();
        }
        finally {
            os.close();
        }
    }

    public Object parseBody(HttpMessage httpMessage) throws IOException {
        HttpServletRequest request = httpMessage.getRequest();
        if ("GET".equals(request.getMethod())) {
            return null;
        }
        if (this.isUseReaderForPayload()) {
            return request.getReader();
        }
        return HttpConverter.toInputStream(request);
    }

    public boolean isUseReaderForPayload() {
        return this.useReaderForPayload;
    }

    public void setUseReaderForPayload(boolean useReaderForPayload) {
        this.useReaderForPayload = useReaderForPayload;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }
}

